ORCA/M Asm65816 2.1.0

0001 C800                       TITLE '$C800 Video Firmware'
0002 C800
0003 C800              ;	This EdAsm/Asm816 source code file was converted to AsmIIGS
0004 C800              ;	by EdAsmCvtIIGS version 1.2d5 on 5/9/91 at 9:34:13 PM
0005 C800
0006 C800              * This entry point is only used by Pascal 1.0
0007 C800
0008 C800              * Maintained entry point $C800
0009 C800 4C B0 C9              JMP   PINIT1_0                 ;PASCAL 1.0 INIT
0010 C803
0011 C803              * BASIC initialization:
0012 C803
0013 C803              * This is called by the $C3 space only after a PR#3 or
0014 C803              * the equivalent (a JSR $C300).
0015 C803
0016 C803              * It causes a copy of the $F8 ROM to be placed in the
0017 C803              * language card if the language card is switched in and
0018 C803              * the ID byte doesn't match.  It sets up all the  
0019 C803              * screenhole variables to support its operation.
0020 C803              * Then it clears the screen and prints the character that
0021 C803              * was in the accumulator upon entry.
0022 C803
0023 C803              BASICINIT EQU   *
0024 C803 20 89 CE              JSR   COPYROM                  ;If LC in, copy F8 to it
0025 C806 20 2A C8              JSR   C3HOOKS                  ;out=$C307, in=$C305 
0026 C809 20 CB CC              JSR   DO40                     ;set full 40-col window
0027 C80C A9 00                 LDA   #$00                     ;Set 80 column cursor
0028 C80E 8F 35 01 E1           STA   >CURSOR                  ;
0029 C812 A9 01                 LDA   #M_MOUSE                 ;init with mouse text off
0030 C814 8D FB 04              STA   MODE                     ;Set BASIC video mode 
0031 C817 06 21                 ASL   WNDWDTH                  ;Set 80-column window
0032 C819 8D 01 C0              STA   SET80COL                 ; and enable 80 store
0033 C81C 8D 0D C0              STA   SET80VID                 ; and 80 video.
0034 C81F
0035 C81F              * HOME & CLEAR:
0036 C81F
0037 C81F 8D 0F C0              STA   SETALTCHAR               ;SET NORM/INV LCASE
0038 C822 20 37 CC              JSR   X_FF                     ;CLEAR IT
0039 C825 AC 7B 05              LDY   OURCH                    ;set up cursor for store
0040 C828 80 32                 BRA   BPRINT                   ;always print a character
0041 C82A
0042 C82A A9 07        C3HOOKS  LDA   #<BASICOUT               ;set output hook first
0043 C82C 85 36                 STA   CSWL
0044 C82E A9 C3                 LDA   #>C300
0045 C830 85 37                 STA   CSWH
0046 C832
0047 C832              * C3IN is called by IN#0 if CSWH = #$C3
0048 C832
0049 C832 A9 05        C3IN     LDA   #<BASICIN                ;set input hook
0050 C834 85 38                 STA   KSWL
0051 C836 A9 C3                 LDA   #>C300
0052 C838 85 39                 STA   KSWH
0053 C83A 60                    RTS                            ;exit with A=$C3 for IN#0 stuff
0054 C83B
0055 C83B E6 4E        GETKEY   INC   RNDL                     ;BUMP RANDOM SEED
0056 C83D D0 02                 BNE   @1
0057 C83F E6 4F                 INC   RNDH
0058 C841 20 74 CF     @1       JSR   XRDKBD                   ;KEYPRESS?
0059 C844 10 F5                 BPL   GETKEY                   ;=>NOPE
0060 C846 60                    RTS   
0061 C847
0062 C847 C6 CA C2              DC B:$C6,$CA,$C2
0063 C84A
0064 C84A              ****************************************
0065 C84A              * PASCAL 1.0 INPUT HOOK:
0066 C84A              ****************************************
0067 C84A
0068 C84A                       FillTo $C84D                   ;Pad to next entry point
0069 C84D
0070 C84D              * Maintained entry point $C84D
0071 C84D 4C 6F C3              JMP   JPREAD                   ;=>GO TO STANDARD READ
0072 C850
0073 C850
0074 C850              * BIN and BOUT are used when characters are
0075 C850              * input and output by the $F8 ROM while 80VID
0076 C850              * is on.  They cannot use the $C3 entry points
0077 C850              * because that switches in the $C8 space, causing
0078 C850              * possible conflict with other $C8 users.
0079 C850              * These routines are only called by the Monitor space.
0080 C850
0081 C850              * These entry points will only work if the card was
0082 C850              * first initialized using a PR#3.  80 columns will not
0083 C850              * work simply by turning on the 80VID flag.
0084 C850
0085 C850 A4 35        BOUT     LDY   YSAV1                    ;load Y stuffed by $F8 ROM
0086 C852 18                    CLC                            ;signal an output 
0087 C853 B0                    OPCODE BCS                     ;skip SEC
0088 C854 38           BIN      SEC                            ;signal an input
0089 C855 8D 7B 06              STA   CHAR                     ;save the char
0090 C858 5A                    PHY                            ;save Y
0091 C859 DA                    PHX                            ;save X
0092 C85A              C8BASIC  EQU   *                        ;BASIC IN/OUT
0093 C85A B0 6E                 BCS   BINPUT                   ;=>input a character
0094 C85C                       EJECT 
0095 C85C
0096 C85C              * This is the place where characters printed using the
0097 C85C              * CSW hook are actually printed (or executed if they are
0098 C85C              * control characters).
0099 C85C
0100 C85C 20 73 C9     BPRINT   JSR   CSETUP                   ;setup user cursor
0101 C85F AD 7B 06              LDA   CHAR                     ;GET CHARACTER
0102 C862 C9 8D                 CMP   #$8D                     ;IS IT C/R?
0103 C864 D0 18                 BNE   @2                       ;=>don't wait, OURCH ok 
0104 C866 AE 00 C0              LDX   KBD                      ;IS KEY PRESSED?
0105 C869 10 13                 BPL   @2                       ;NO
0106 C86B E0 93                 CPX   #$93                     ;IS IT CTL-S?
0107 C86D D0 0F                 BNE   @2                       ;NO, IGNORE IT
0108 C86F 2C 10 C0              BIT   KBDSTRB                  ;CLEAR STROBE
0109 C872              @1       EQU   *
0110 C872 AE 00 C0              LDX   KBD                      ;WAIT FOR NEXT KEYPRESS
0111 C875 10 FB                 BPL   @1
0112 C877 E0 83                 CPX   #$83                     ;IF CTL-C, LEAVE IT
0113 C879 F0 03                 BEQ   @2                       ; IN THE KBD BUFFER
0114 C87B 2C 10 C0              BIT   KBDSTRB                  ;CLEAR OTHER CHARACTER
0115 C87E              @2       EQU   *
0116 C87E EB                    XBA                            ;Preserve 'A' during test
0117 C87F AF 37 01 E1           LDA   >CHGCURFLG               ;'+'/'-' no change / change cursor
0118 C883 10 0E                 BPL   @22                      ;
0119 C885 EB                    XBA                            ;Recall new cursor character
0120 C886 8F 35 01 E1           STA   >CURSOR                  ;New cursor
0121 C88A A9 01                 LDA   #$01                     ;Reset flag
0122 C88C 8F 37 01 E1           STA   >CHGCURFLG               ;
0123 C890 18                    CLC                            ;Save done OK
0124 C891 80 1D                 BRA   @4                       ;Exit normally
0125 C893
0126 C893              @22      EQU   *
0127 C893 EB                    XBA                            ;Restore original 'A' value
0128 C894 29 7F                 AND   #$7F                     ;drop possible hi bit
0129 C896 C9 20                 CMP   #$20                     ;IS IT CONTROL CHAR? 
0130 C898 B0 05                 BCS   @3                       ;=>NOPE
0131 C89A 20 7C CA              JSR   CTLCHAR0                 ;execute CTL if M_CTL ok
0132 C89D 80 11                 BRA   @4                       ;=>enable ctl chrs
0133 C89F
0134 C89F              * NOT A CTL CHAR. PRINT IT.
0135 C89F
0136 C89F              @3       EQU   *
0137 C89F AD 7B 06              LDA   CHAR                     ;get char (all 8 bits)
0138 C8A2 20 E7 CD              JSR   STORCH                   ;and display it
0139 C8A5
0140 C8A5              * BUMP THE CURSOR HORIZONTAL:
0141 C8A5
0142 C8A5 C8                    INY                            ;bump it 
0143 C8A6 8C 7B 05              STY   OURCH                    ;are we past the 
0144 C8A9 C4 21                 CPY   WNDWDTH                  ; end of the line?
0145 C8AB 90 03                 BCC   @4                       ;=>NO, NO PROBLEM
0146 C8AD 20 EA CA              JSR   X_CR                     ;YES, DO C/R 
0147 C8B0
0148 C8B0              * M_CTL is set by RDCHAR and cleared here, after each
0149 C8B0              * character is displayed.
0150 C8B0
0151 C8B0              @4       EQU   *                        ;enable printing of control chars
0152 C8B0 A9 08                 LDA   #M_CTL
0153 C8B2 1C FB 04              TRB   MODE
0154 C8B5 AD 7B 05     BIORET   LDA   OURCH                    ;get newest cursor position
0155 C8B8 2C 1F C0              BIT   RD80VID                  ;IN 80-MODE?
0156 C8BB 10 02                 BPL   @1                       ;=>no, set other cursors 
0157 C8BD A9 00                 LDA   #0                       ;pin CH to 0 for 80 columns
0158 C8BF 85 24        @1       STA   CH
0159 C8C1 8D 7B 04              STA   OLDCH                    ;REMEMBER THE SETTING
0160 C8C4 FA                    PLX                            ;RESTORE
0161 C8C5 7A                    PLY                            ;X AND Y
0162 C8C6 AD 7B 06              LDA   CHAR
0163 C8C9 60                    RTS                            ;RETURN TO BASIC
0164 C8CA                       EJECT 
0165 C8CA
0166 C8CA              * BASIC input entry point called by entry point in the
0167 C8CA              * $C3 space.  This is the way things normally happen.
0168 C8CA
0169 C8CA              BINPUT   EQU   *
0170 C8CA A4 24                 LDY   CH
0171 C8CC AD 7B 06              LDA   CHAR
0172 C8CF 91 28                 STA   (BASL),Y
0173 C8D1 20 73 C9              JSR   CSETUP                   ;get newest cursor
0174 C8D4
0175 C8D4
0176 C8D4              BINPUT4  EQU   *
0177 C8D4 20 C9 CE              JSR   SHOWCUR                  ;Show current cursor
0178 C8D7              @1       EQU   *
0179 C8D7 20 FC CE              JSR   UPDATE                   ;Flash and loop for key
0180 C8DA 10 FB                 BPL   @1                       ;
0181 C8DC 8D 7B 06              STA   CHAR                     ;Save character for other routines
0182 C8DF A8                    TAY                            ;preserve acc.
0183 C8E0
0184 C8E0              * On pure input, an uninterpreted character code should
0185 C8E0              * be returned.  If M_CTL is set, however, escape functions
0186 C8E0              * are enabled, and CTL-U causes the character under the
0187 C8E0              * cursor to be picked up from the screen.
0188 C8E0              * M_CTL is set whenever a character is requested using
0189 C8E0              * RDCHAR in the $F8 ROM.
0190 C8E0
0191 C8E0 AD FB 04              LDA   MODE                     ;is escape mode enabled?
0192 C8E3 29 08                 AND   #M_CTL
0193 C8E5 F0 CE                 BEQ   BIORET                   ;=>no,return 
0194 C8E7 C0 8D                 CPY   #$8D                     ;was it a CR
0195 C8E9 D0 05                 BNE   @2                       ;=>nope, not a CR
0196 C8EB A9 08                 LDA   #M_CTL                   ;else end of line...  
0197 C8ED 1C FB 04              TRB   MODE                     ; disable escape 
0198 C8F0              @2       EQU   *
0199 C8F0 C0 9B                 CPY   #$9B                     ;ESCAPE KEY?
0200 C8F2 F0 0E                 BEQ   ESCAPING                 ;=>YES IT IS
0201 C8F4
0202 C8F4              * Not an escape sequence.  Check for control-u.
0203 C8F4
0204 C8F4 C0 95                 CPY   #$95                     ;is it control-U?
0205 C8F6 D0 BD                 BNE   BIORET                   ;no, return to caller
0206 C8F8 20 B8 CD              JSR   PICKY                    ;Pick up the char
0207 C8FB 09 80                 ORA   #$80                     ;always pick as normal
0208 C8FD 8D 7B 06              STA   CHAR                     ;save keystroke
0209 C900 D0 B3                 BNE   BIORET                   ;=>(always) return to caller
0210 C902
0211 C902                       EJECT 
0212 C902              * Start an escape sequence.  If the next character 
0213 C902              * pressed is one of the following, it is executed. 
0214 C902              * Otherwise it is ignored.
0215 C902              *
0216 C902              *    @ - home & clear 
0217 C902              *    E - clear to end of line 
0218 C902              *    F - clear to end of screen 
0219 C902              *    I - move cursor up 
0220 C902              *    J - move cursor left 
0221 C902              *    K - move cursor right 
0222 C902              *    M - move cursor down 
0223 C902              *    4 - enter 40 column mode 
0224 C902              *    8 - enter 80 column mode 
0225 C902              * CTL-D- disable the printing of control characters
0226 C902              * CTL-E- enable the printing of control characters
0227 C902              * CTL-Q- quit (PR#0/IN#0)
0228 C902              *   The four arrow keys (as IJKM)
0229 C902
0230 C902              ESCAPING EQU   *
0231 C902 20 37 CE              JSR   ESCON                    ;ESCAPE CURSOR ON
0232 C905 20 3B C8              JSR   GETKEY                   ;GET ESCAPE FUNCTION
0233 C908 20 49 CE              JSR   ESCOFF                   ;REPLACE ORIGINAL CHARACTER
0234 C90B 20 AD CD              JSR   UPSHFT                   ;upshift the char
0235 C90E 29 7F                 AND   #$7F                     ;DROP HI BIT
0236 C910 A0 10                 LDY   #ESCNUM-1                ;COUNT/INDEX
0237 C912 D9 62 C9     @1       CMP   ESCTAB,Y                 ;IS IT A VALID ESCAPE?
0238 C915 F0 05                 BEQ   @2                       ;=>YES
0239 C917 88                    DEY   
0240 C918 10 F8                 BPL   @1                       ;TRY 'EM ALL...
0241 C91A 30 0F                 BMI   @3                       ;=>MAYBE IT'S A SPECIAL ONE
0242 C91C
0243 C91C              @2       EQU   *
0244 C91C B9 51 C9              LDA   ESCCHAR,Y                ;GET CHAR TO "PRINT"
0245 C91F 29 7F                 AND   #$7F                     ;DROP HI BIT (FLAG)
0246 C921 20 7F CA              JSR   CTLCHAR                  ;EXECUTE IT
0247 C924 B9 51 C9              LDA   ESCCHAR,Y                ;GET FLAG
0248 C927 30 D9                 BMI   ESCAPING                 ;=>STAY IN ESCAPE MODE
0249 C929 10 A9                 BPL   BINPUT4                  ;=>QUIT ESCAPE MODE
0250 C92B
0251 C92B              @3       EQU   *
0252 C92B A8                    TAY                            ;put char here
0253 C92C AD FB 04              LDA   MODE                     ;so we can put this here
0254 C92F C0 11                 CPY   #$11                     ;was it Quit?
0255 C931 D0 0B                 BNE   @4                       ;=>no 
0256 C933 20 E6 CC              JSR   X_NAK                    ;do the quitting stuff
0257 C936 A9 98                 LDA   #$98                     ;make it look like
0258 C938 8D 7B 06              STA   CHAR                     ;CTL-X was pressed
0259 C93B 4C B5 C8              JMP   BIORET                   ;=>quit the card forever
0260 C93E
0261 C93E C0 05        @4       CPY   #$05                     ;was it CTL-E for enable
0262 C940 D0 07                 BNE   @5                       ;=>no
0263 C942 29 DF                 AND   #255-M_CTL2              ;yes, enable ctl chars
0264 C944 8D FB 04     @6       STA   MODE                     ;save new mode
0265 C947 80 8B        @7       BRA   BINPUT4                  ;=> exit escape mode
0266 C949
0267 C949 C0 04        @5       CPY   #$04                     ;was it CTL-D for disable
0268 C94B D0 FA                 BNE   @7                       ;=>no, exit escape mode
0269 C94D 09 20                 ORA   #M_CTL2                  ;disable ctl chars
0270 C94F D0 F3                 BNE   @6                       ;=> exit escape mode
0271 C951
0272 C951              * This table contains the control characters which, 
0273 C951              * when executed, carry out the escape functions. If
0274 C951              * the high bit of the character is set, it means that
0275 C951              * escape mode should not be exited after execution of
0276 C951              * the character.
0277 C951
0278 C951              ESCCHAR  EQU   *
0279 C951 0C                    DC B:$0C                       ;@: FORMFEED 
0280 C952 1C                    DC B:$1C                       ;A: FS
0281 C953 08                    DC B:$08                       ;B: BS
0282 C954 0A                    DC B:$0A                       ;C: LF
0283 C955 1F                    DC B:$1F                       ;D: US
0284 C956 1D                    DC B:$1D                       ;E: GS 
0285 C957 0B                    DC B:$0B                       ;F: VT 
0286 C958 9F                    DC B:$1F+$80                   ;I: US (STAY ESC) 
0287 C959 88                    DC B:$08+$80                   ;J: BS (STAY ESC) 
0288 C95A 9C                    DC B:$1C+$80                   ;K: FS (STAY ESC) 
0289 C95B 8A                    DC B:$0A+$80                   ;M: LF (STAY ESC) 
0290 C95C 11                    DC B:$11                       ;4 :DC1 
0291 C95D 12                    DC B:$12                       ;8 :DC2 
0292 C95E 88                    DC B:$08+$80                   ;<-:BS (STAY ESC) 
0293 C95F 8A                    DC B:$0A+$80                   ;DN:LF (STAY ESC) 
0294 C960 9F                    DC B:$1F+$80                   ;UP:US (STAY ESC) 
0295 C961 9C                    DC B:$1C+$80                   ;->:FS (STAY ESC)
0296 C962
0297 C962                       MSB   OFF                      ;high bit already masked
0298 C962              ESCTAB   EQU   *
0299 C962 40                    DC B:'@'
0300 C963 41                    DC B:'A'                       ;HANDLE OLD ESCAPES
0301 C964 42                    DC B:'B'
0302 C965 43                    DC B:'C'
0303 C966 44                    DC B:'D'
0304 C967 45                    DC B:'E'
0305 C968 46                    DC B:'F'
0306 C969 49                    DC B:'I'
0307 C96A 4A                    DC B:'J'
0308 C96B 4B                    DC B:'K'
0309 C96C 4D                    DC B:'M'
0310 C96D 34                    DC B:'4'
0311 C96E 38                    DC B:'8'
0312 C96F 08                    DC B:$08                       ;LEFT ARROW
0313 C970 0A                    DC B:$0A                       ;DOWN ARROW
0314 C971 0B                    DC B:$0B                       ;UP   ARROW
0315 C972 15                    DC B:$15                       ;RIGHT ARROW
0316 C973              ESCNUM   EQU   *-ESCTAB
0317 C973                       MSB   ON
0318 C973
0319 C973
0320 C973              * CSETUP compensates for everything that the user 
0321 C973              * can do to change the cursor status: poke CV, CH,
0322 C973              * OURCH, WNDWDTH.  It updates the video firmware's 
0323 C973              * versions of these values for its own use.
0324 C973              * COPY USER'S CURSOR IF IT DIFFERS FROM
0325 C973              *  WHAT WE LAST PUT THERE:
0326 C973
0327 C973 A4 25        CSETUP   LDY   CV                       ;set up OURCV
0328 C975 8C FB 05              STY   OURCV
0329 C978
0330 C978              * ON CURSORS.  Whenever the horizontal cursor position is
0331 C978              * needed, a call to GETCUR is done. This is the equivalent
0332 C978              * of a LDY CH.  This returns the current cursor for II and
0333 C978              * //e mode, which may have been poked as either CH or OURCH.
0334 C978
0335 C978              * It also forces CH and OLDCH to 0 if 80 column mode active.
0336 C978              * This prevents LDY CH, STA (BASL),Y from trashing non screen
0337 C978              * memory. It works just like the //e. 
0338 C978
0339 C978              * All routines that update the cursor's horizontal position
0340 C978              * are here.  This ensures that the newest value of the cursor
0341 C978              * is always used, and that 80 column CH is always 0.
0342 C978
0343 C978              * GETCUR only affects the Y register
0344 C978
0345 C978 A4 24        GETCUR   LDY   CH                       ;if CH=OLDCH, then
0346 C97A CC 7B 04              CPY   OLDCH                    ;OURCH is valid
0347 C97D D0 03                 BNE   @1                       ;=>else CH must have been changed
0348 C97F AC 7B 05              LDY   OURCH                    ;use OURCH
0349 C982 C4 21        @1       CPY   WNDWDTH                  ;is the value too big 
0350 C984 90 02                 BCC   GETCUR2                  ;=>no, fits just fine
0351 C986 A0 00                 LDY   #0                       ;else force CH to 0
0352 C988
0353 C988              * GETCUR2 is commonly used to set the current cursor
0354 C988              * position when Y can be used.
0355 C988
0356 C988              GETCUR2  EQU   *
0357 C988 8C 7B 05              STY   OURCH                    ;update real cursor
0358 C98B 2C 1F C0              BIT   RD80VID                  ;80 columns?
0359 C98E 10 02                 BPL   @3                       ;=>no, set all cursors
0360 C990 A0 00                 LDY   #0                       ;yes, peg CH to 0
0361 C992 84 24        @3       STY   CH
0362 C994 8C 7B 04              STY   OLDCH
0363 C997 AC 7B 05              LDY   OURCH                    ;get cursor
0364 C99A 60                    RTS                            ;and fly...
0365 C99B
0366 C99B
0367 C99B              * DECCHFF decrements the current cursor
0368 C99B
0369 C99B              DECCHFF  EQU   *
0370 C99B 20 78 C9              JSR   GETCUR                   ;Get current CH
0371 C99E 88                    DEY                            ;Decrement it
0372 C99F              DECCHFF2 EQU   *
0373 C99F 20 88 C9              JSR   GETCUR2                  ;Save new CH
0374 C9A2 98                    TYA                            ; and get new CH into 'A'
0375 C9A3 60                    RTS                            ;Back to caller
0376 C9A4
0377 C9A4              WDTCHFF  EQU   *
0378 C9A4 3A                    DEC   A                        ;Dec window width
0379 C9A5 A8                    TAY                            ;'Y' = new cursor position
0380 C9A6 80 F7                 BRA   DECCHFF2                 ;Continue this way
0381 C9A8
0382 C9A8
0383 C9A8                       EJECT 
0384 C9A8
0385 C9A8              ****************************************
0386 C9A8              * PASCAL 1.0 OUTPUT HOOK:
0387 C9A8              ****************************************
0388 C9A8
0389 C9A8                       FillTo $C9AA                   ;Pad to next entry point
0390 C9AA
0391 C9AA              * Maintained entry point $C9AA
0392 C9AA AD 7B 06              LDA   CHAR                     ;GET OUTPUT CHARACTER
0393 C9AD 4C 75 C3              JMP   JPWRITE                  ;=>USE STANDARD WRITE
0394 C9B0
0395 C9B0
0396 C9B0              ****************************************
0397 C9B0              * PASCAL INITIALIZATION:
0398 C9B0              * Disable printing of mouse text
0399 C9B0              ****************************************
0400 C9B0              PINIT1_0 EQU   *
0401 C9B0 A9 83                 LDA   #M_PASCAL+M_PAS1_0+M_MOUSE
0402 C9B2 D0 02                 BNE   PINIT2                   ;=>always
0403 C9B4              PINIT    EQU   *
0404 C9B4 A9 81                 LDA   #M_PASCAL+M_MOUSE        ;SAY WE'RE
0405 C9B6              PINIT2   EQU   *
0406 C9B6 8D FB 04              STA   MODE                     ; and save it
0407 C9B9 8D 01 C0              STA   SET80COL                 ;ENABLE 80 STORE
0408 C9BC 8D 0D C0              STA   SET80VID                 ; AND 80 VIDEO
0409 C9BF 8D 0F C0              STA   SETALTCHAR               ;NORM+INV LCASE
0410 C9C2 A9 00                 LDA   #$00                     ;Set up inverse cursor
0411 C9C4 8F 35 01 E1           STA   >CURSOR                  ;
0412 C9C8 20 69 CE              JSR   PSETUP                   ;set window and cursor 
0413 C9CB 20 37 CC              JSR   X_FF                     ;HOME & CLEAR IT
0414 C9CE 80 47                 BRA   DOBASL                   ;fix OLDBASL/H, display cursor, exit
0415 C9D0
0416 C9D0              ****************************************
0417 C9D0              * PASCAL INPUT:
0418 C9D0              *
0419 C9D0              * Character always returned with high bit clear.
0420 C9D0              *
0421 C9D0              ****************************************
0422 C9D0              PASCALREAD EQU   *
0423 C9D0 20 69 CE              JSR   PSETUP                   ;SETUP ZP STUFF
0424 C9D3 20 3B C8              JSR   GETKEY                   ;GET A KEYSTROKE
0425 C9D6 29 7F                 AND   #$7F                     ;DROP HI BIT
0426 C9D8 8D 7B 06              STA   CHAR                     ;SAVE THE CHAR
0427 C9DB A2 00                 LDX   #0                       ;IORESULT='GOOD'
0428 C9DD AD FB 04              LDA   MODE                     ;ARE WE IN 1.0-MODE?
0429 C9E0 29 02                 AND   #M_PAS1_0
0430 C9E2 F0 02                 BEQ   @1                       ;=>NOPE
0431 C9E4 A2 C3                 LDX   #>C300                   ;YES, RETURN CN IN X 
0432 C9E6
0433 C9E6              @1       EQU   *
0434 C9E6 AD 7B 06              LDA   CHAR                     ;RESTORE CHAR
0435 C9E9 60                    RTS   
0436 C9EA
0437 C9EA              * PASCAL OUTPUT:
0438 C9EA              * Note:  to be executed, control characters must have
0439 C9EA              * their high bits cleared.  All other characters are
0440 C9EA              * displayed regardless of their high bits.
0441 C9EA
0442 C9EA              PWRITE   EQU   *
0443 C9EA 29 7F                 AND   #$7F                     ;clear high bits
0444 C9EC AA                    TAX                            ;save character
0445 C9ED 20 69 CE              JSR   PSETUP                   ;SETUP ZP STUFF, don't set ROM 
0446 C9F0 A9 08                 LDA   #M_GOXY                  ;ARE WE DOING GOTOXY?
0447 C9F2 2C FB 04              BIT   MODE
0448 C9F5 D0 30                 BNE   GETX                     ;=>Doing X or Y?
0449 C9F7 8A                    TXA                            ;now check for control char
0450 C9F8 2C 26 CA              BIT   PRTS                     ;is it control?
0451 C9FB F0 4E                 BEQ   PCTL                     ;=>yes, do control
0452 C9FD AC 7B 05              LDY   OURCH                    ;get horizontal position
0453 CA00 24 32                 BIT   INVFLG                   ;check for inverse
0454 CA02 10 02                 BPL   @1                       ;inverse, go store it
0455 CA04 09 80                 ORA   #$80
0456 CA06 20 F9 CD     @1       JSR   PSTORY                   ;now store it (erasing cursor)
0457 CA09 C8                    INY                            ;INC CH 
0458 CA0A 8C 7B 05              STY   OURCH
0459 CA0D C4 21                 CPY   WNDWDTH
0460 CA0F 90 06                 BCC   DOBASL
0461 CA11 9C 7B 05              STZ   OURCH                    ;do carriage return
0462 CA14 20 71 CB              JSR   X_LF                     ;and linefeed 
0463 CA17 A5 28        DOBASL   LDA   BASL                     ;save BASL for pascal
0464 CA19 8D 7B 07              STA   OLDBASL
0465 CA1C A5 29                 LDA   BASH
0466 CA1E 8D FB 07              STA   OLDBASH
0467 CA21 20 53 CE     PWRITERET JSR   PASINV                  ;display new cursor
0468 CA24 A2 00                 LDX   #$0                      ;return with no error
0469 CA26 60           PRTS     RTS   
0470 CA27
0471 CA27              *  HANDLE GOTOXY STUFF:
0472 CA27
0473 CA27 20 53 CE     GETX     JSR   PASINV                   ;turn off cursor
0474 CA2A 8A                    TXA                            ;get character 
0475 CA2B 38                    SEC   
0476 CA2C E9 20                 SBC   #32                      ;MAKE BINARY
0477 CA2E 2C FB 06              BIT   XCOORD                   ;doing X?
0478 CA31 30 2C                 BMI   PSETX                    ;=>yes, set it
0479 CA33
0480 CA33              * Set Y and do the GOTOXY 
0481 CA33
0482 CA33 8D FB 05              STA   OURCV                    ;Do GETY
0483 CA36 85 25                 STA   CV
0484 CA38 20 64 CA              JSR   BASCALCC                 ;calc base addr 
0485 CA3B AD FB 06              LDA   XCOORD
0486 CA3E 8D 7B 05              STA   OURCH                    ;set cursor horizontal
0487 CA41 A9 F7                 LDA   #255-M_GOXY              ;turn off gotoxy 
0488 CA43 2D FB 04              AND   MODE
0489 CA46 8D FB 04              STA   MODE
0490 CA49 D0 CC                 BNE   DOBASL                   ;=>DONE (ALWAYS TAKEN) 
0491 CA4B
0492 CA4B 20 53 CE     PCTL     JSR   PASINV                   ;turn off cursor
0493 CA4E 8A                    TXA                            ;get char
0494 CA4F C9 1E                 CMP   #$1E                     ;is it gotoXY?
0495 CA51 F0 05                 BEQ   STARTXY                  ;=>yes, start it up
0496 CA53 20 7F CA              JSR   CTLCHAR                  ;EXECUTE IT IF POSSIBLE
0497 CA56 80 BF                 BRA   DOBASL                   ;=>update BASL/H, cursor, exit 
0498 CA58
0499 CA58              * START THE GOTOXY SEQUENCE: 
0500 CA58
0501 CA58              STARTXY  EQU   *
0502 CA58 A9 08                 LDA   #M_GOXY
0503 CA5A 0C FB 04              TSB   MODE                     ;turn on gotoxy
0504 CA5D A9 FF                 LDA   #$FF                     ;set XCOORD to -1
0505 CA5F 8D FB 06     PSETX    STA   XCOORD                   ;set X
0506 CA62 80 BD                 BRA   PWRITERET                ;=>display cursor and exit
0507 CA64                       EJECT 
0508 CA64              * Do the normal monitor ROM BASCALCC
0509 CA64
0510 CA64              BASCALCC EQU   *
0511 CA64 48                    PHA   
0512 CA65 4A                    LSR   A
0513 CA66 29 03                 AND   #$03
0514 CA68 09 04                 ORA   #$04
0515 CA6A 85 29                 STA   BASH
0516 CA6C 68                    PLA   
0517 CA6D 29 18                 AND   #$18
0518 CA6F 90 02                 BCC   @1
0519 CA71 69 7F                 ADC   #$7F
0520 CA73 85 28        @1       STA   BASL
0521 CA75 0A                    ASL   A
0522 CA76 0A                    ASL   A
0523 CA77 05 28                 ORA   BASL                     ;Done this way since some programs
0524 CA79 85 28                 STA   BASL                     ; depend on BASL on exit.
0525 CA7B 60                    RTS   
0526 CA7C
0527 CA7C              ****************************************
0528 CA7C              * NAME    : CTLCHAR0 
0529 CA7C              * FUNCTION: Execute CTL char if M_CTL=0 
0530 CA7C              * INPUT   : AC=CHAR 
0531 CA7C              * OUTPUT  : 'BCS' if not executed 
0532 CA7C              *         : 'BCC' if executed
0533 CA7C              * VOLATILE: NOTHING
0534 CA7C              * CALLS   : MANY THINGS 
0535 CA7C              ****************************************
0536 CA7C
0537 CA7C E2 40        CTLCHAR0 SEP   #$40                     ;set V (use M_CTL) 
0538 CA7E 50                    OPCODE BVC                     ;skip CLV 
0539 CA7F
0540 CA7F              ****************************************
0541 CA7F              * NAME    : CTLCHAR
0542 CA7F              * FUNCTION: Always execute CTL char 
0543 CA7F              * INPUT   : AC=CHAR
0544 CA7F              * OUTPUT  : 'BCS' if not executed 
0545 CA7F              *         : 'BCC' if ctl executed 
0546 CA7F              * VOLATILE: NOTHING
0547 CA7F              * CALLS   : MANY THINGS 
0548 CA7F              ****************************************
0549 CA7F
0550 CA7F B8           CTLCHAR  CLV                            ;clear V (ignore M_CTL)
0551 CA80 8D 7B 07              STA   TEMP1                    ;TEMP SAVE OF CHAR
0552 CA83 48                    PHA                            ;SAVE AC
0553 CA84 5A                    PHY                            ;SAVE Y
0554 CA85
0555 CA85 AC 7B 07              LDY   TEMP1                    ;GET CHAR IN QUESTION
0556 CA88 C0 05                 CPY   #$05                     ;IS IT NUL..EOT?
0557 CA8A 90 13                 BCC   @3                       ;=>YES, NOT USED
0558 CA8C B9 4D CB              LDA   CTLADH-5,Y               ;Get high byte of address 
0559 CA8F F0 0E                 BEQ   @3                       ;=>ctl not implemented
0560 CA91 50 12                 BVC   @20                      ;=> CLTCHAR: always execute
0561 CA93 30 10                 BMI   @20                      ;=>CR,BEL,LF,BS always done
0562 CA95 8D 7B 07              STA   TEMP1                    ;save high byte of address
0563 CA98 AD FB 04              LDA   MODE                     ;if control chars
0564 CA9B 29 28                 AND   #M_CTL+M_CTL2            ;are enabled
0565 CA9D F0 03                 BEQ   @2                       ;=>then go do them
0566 CA9F
0567 CA9F              @3       EQU   *
0568 CA9F 38                    SEC                            ;SAY 'NOT CTL'
0569 CAA0 B0 09                 BCS   @4                       ;=>DONE
0570 CAA2
0571 CAA2 AD 7B 07     @2       LDA   TEMP1                    ;get address back
0572 CAA5              @20      EQU   *
0573 CAA5 09 80                 ORA   #$80                     ;hi bit always set
0574 CAA7 20 AE CA              JSR   @5                       ;EXECUTE SUBROUTINE
0575 CAAA
0576 CAAA 18                    CLC                            ;SAY 'CTL CHAR EXECUTED'
0577 CAAB              @4       EQU   *
0578 CAAB 7A                    PLY                            ;Restore Y
0579 CAAC 68                    PLA                            ;  and A
0580 CAAD 60                    RTS   
0581 CAAE
0582 CAAE              @5       EQU   *
0583 CAAE 48                    PHA                            ;PUSH ONTO STACK FOR 
0584 CAAF B9 32 CB              LDA   CTLADL-5,Y               ; TRANSFER TRICK
0585 CAB2 48                    PHA   
0586 CAB3 60                    RTS                            ;XFER TO ROUTINE
0587 CAB4
0588 CAB4              * Turn cursor on for Pascal only
0589 CAB4
0590 CAB4 AD FB 04     X_CUR_ON LDA   MODE                     ;get mode byte
0591 CAB7 10 05                 BPL   CURON_X                  ;=>not pascal, don't do it
0592 CAB9 29 EF                 AND   #255-M_CURSOR            ;clear cursor bit
0593 CABB 8D FB 04     SAVCUR   STA   MODE                     ;save it
0594 CABE 60           CURON_X  RTS                            ;and exit
0595 CABF
0596 CABF              * Turn cursor off for Pascal only.
0597 CABF              * Cursor is not displayed during call.
0598 CABF
0599 CABF AD FB 04     X_CUR_OFF LDA   MODE                    ;get mode byte
0600 CAC2 10 FA                 BPL   CURON_X                  ;=>not pascal, don't do it
0601 CAC4 09 10                 ORA   #M_CURSOR                ;turn on cursor bit
0602 CAC6 D0 F3                 BNE   SAVCUR                   ;save and exit
0603 CAC8
0604 CAC8              * EXECUTE BELLC:
0605 CAC8
0606 CAC8              X_BELLC  EQU   *
0607 CAC8 AD 68 C0              LDA   STATEREG                 ;Save where we are
0608 CACB 48                    PHA                            ; on stack for later.
0609 CACC 09 08                 ORA   #$08                     ;Map in monitor ROM
0610 CACE 8D 68 C0              STA   STATEREG                 ;
0611 CAD1 20 DD FB              JSR   BELL1                    ;Call monitor regular bell routine
0612 CAD4 68                    PLA                            ;Restore memory state of machine
0613 CAD5 8D 68 C0              STA   STATEREG                 ;
0614 CAD8 60                    RTS                            ;Back to caller
0615 CAD9
0616 CAD9              * EXECUTE BACKSPACE:
0617 CAD9
0618 CAD9              X_BS     EQU   *
0619 CAD9 CE 7B 05              DEC   OURCH                    ;BACK UP CH
0620 CADC 10 0B                 BPL   @1                       ;=>DONE
0621 CADE A5 21                 LDA   WNDWDTH                  ;BACK UP TO PRIOR LINE
0622 CAE0 8D 7B 05              STA   OURCH                    ;SET CH
0623 CAE3 CE 7B 05              DEC   OURCH
0624 CAE6 20 0B CB              JSR   X_US                     ;NOW DO REV LINEFEED
0625 CAE9              @1       EQU   *
0626 CAE9 60                    RTS   
0627 CAEA
0628 CAEA              * EXECUTE CARRIAGE RETURN:
0629 CAEA
0630 CAEA              X_CR     EQU   *
0631 CAEA 9C 7B 05              STZ   OURCH                    ;Back up CH to beginning of line
0632 CAED AD FB 04              LDA   MODE                     ;ARE WE IN BASIC?
0633 CAF0 10 7F                 BPL   X_LF                     ;EXECUTE AUTO LF FOR BASIC
0634 CAF2 60                    RTS                            ;Fall here if Pascal, avoid auto LF
0635 CAF3
0636 CAF3              * EXECUTE HOME:
0637 CAF3
0638 CAF3              X_EM     EQU   *
0639 CAF3 A5 22                 LDA   WNDTOP
0640 CAF5 85 25                 STA   CV
0641 CAF7 9C 7B 05              STZ   OURCH                    ;STUFF CH
0642 CAFA 4C 97 CD              JMP   VTABC                    ;set base for OURCV
0643 CAFD
0644 CAFD              * EXECUTE FORWARD SPACE:
0645 CAFD
0646 CAFD              X_FS     EQU   *
0647 CAFD EE 7B 05              INC   OURCH                    ;BUMP CH
0648 CB00 AD 7B 05              LDA   OURCH                    ;GET THE POSITION
0649 CB03 C5 21                 CMP   WNDWDTH                  ;OFF THE RIGHT SIDE?
0650 CB05 90 03                 BCC   @1                       ;=>NO, GOOD
0651 CB07 20 EA CA              JSR   X_CR                     ;=>YES, WRAP AROUND
0652 CB0A
0653 CB0A              @1       EQU   *
0654 CB0A 60                    RTS   
0655 CB0B
0656 CB0B              * EXECUTE REVERSE LINEFEED:
0657 CB0B
0658 CB0B A5 22        X_US     LDA   WNDTOP                   ;are we at top?
0659 CB0D C5 25                 CMP   CV
0660 CB0F B0 1E                 BCS   X_USRET                  ;=>yes, stay there
0661 CB11 C6 25                 DEC   CV                       ;else go up a line
0662 CB13 4C 97 CD              JMP   VTABC                    ;exit thru VTABC (update OURCV)
0663 CB16
0664 CB16              * EXECUTE "NORMAL VIDEO" 
0665 CB16
0666 CB16              X_SO     EQU   *
0667 CB16 AD FB 04              LDA   MODE                     ;SET MODE BIT
0668 CB19 10 02                 BPL   @1                       ;don't set mode for BASIC
0669 CB1B 29 FB                 AND   #255-M_VMODE             ;SET 'NORMAL'
0670 CB1D A0 FF        @1       LDY   #255
0671 CB1F D0 09                 BNE   STUFFINV                 ;(ALWAYS)
0672 CB21
0673 CB21              * EXECUTE "INVERSE VIDEO" 
0674 CB21
0675 CB21              X_SI     EQU   *
0676 CB21 AD FB 04              LDA   MODE                     ;SET MODE BIT
0677 CB24 10 02                 BPL   @1                       ;don't set mode for BASIC
0678 CB26 09 04                 ORA   #M_VMODE                 ;SET 'INVERSE'
0679 CB28 A0 7F        @1       LDY   #127
0680 CB2A 8D FB 04     STUFFINV STA   MODE                     ;SET MODE
0681 CB2D 84 32                 STY   INVFLG                   ;STUFF FLAG TOO
0682 CB2F 60           X_USRET  RTS   
0683 CB30
0684 CB30              * Enable change cursor mode.
0685 CB30
0686 CB30              X_CHCUR  EQU   *
0687 CB30 A9 81                 LDA   #$81                     ;Set change cursor flag '-'
0688 CB32 8F 37 01 E1           STA   >CHGCURFLG               ;
0689 CB36 60                    RTS                            ; and then exit.
0690 CB37
0691 CB37              CTLADL   EQU   *
0692 CB37 B3                    DC B:X_CUR_ON-1                ;ENQ    (Control-E)
0693 CB38 BE                    DC B:X_CUR_OFF-1               ;ACK   (Control-F)
0694 CB39 C7                    DC B:X_BELLC-1                 	;BEL    (Control-G)
0695 CB3A D8                    DC B:X_BS-1                    	;BS     (Control-H)
0696 CB3B 00                    DC B:0                         	;HT     (Control-I)
0697 CB3C 70                    DC B:X_LF-1                    	;LF     (Control-J)
0698 CB3D 1A                    DC B:X_VT-1                    	;VT     (Control-K)
0699 CB3E 36                    DC B:X_FF-1                    	;FF     (Control-L)
0700 CB3F E9                    DC B:X_CR-1                    	;CR     (Control-M)
0701 CB40 15                    DC B:X_SO-1                    	;SO     (Control-N)
0702 CB41 20                    DC B:X_SI-1                    	;SI     (Control-O)
0703 CB42 00                    DC B:0                         	;DLE    (Control-P)
0704 CB43 8B                    DC B:X_DC1-1                   	;DC1    (Control-Q)
0705 CB44 9D                    DC B:X_DC2-1                   	;DC2    (Control-R)
0706 CB45 00                    DC B:0                         	;DC3    (Control-S)
0707 CB46 00                    DC B:0                         	;DC4    (Control-T)
0708 CB47 E5                    DC B:X_NAK-1                   	;NAK    (Control-U)
0709 CB48 6C                    DC B:SCROLLDN-1                ;SYN    (Control-V)
0710 CB49 83                    DC B:SCROLLUP-1                ;ETB    (Control-W)
0711 CB4A D9                    DC B:MOUSEOFF-1                ;CAN    (Control-X)
0712 CB4B F2                    DC B:X_EM-1                    	;EM     (Control-Y)
0713 CB4C 3B                    DC B:X_SUB-1                   	;SUB    (Control-Z)
0714 CB4D DF                    DC B:MOUSEON-1                 	;       (Control-[)
0715 CB4E FC                    DC B:X_FS-1                    	;FS     (Control-\)
0716 CB4F 3F                    DC B:X_GS-1                    	;GS     (Control-Shift-M or Control-])
0717 CB50 2F                    DC B:X_CHCUR-1                 	;RS     (Control-^)
0718 CB51 0A                    DC B:X_US-1                    	;US     (Control-_)
0719 CB52
0720 CB52              CTLADH   EQU   *
0721 CB52 4A                    DC B:X_CUR_ON-$8001>>8         ;ENQ	(Control-E)
0722 CB53 4A                    DC B:X_CUR_OFF-$8001>>8        ;ACK	(Control-F)
0723 CB54 CA                    DC B:X_BELLC-1>>8              ;BEL      (Control-G)
0724 CB55 CA                    DC B:X_BS-1>>8                 	;BS       (Control-H)
0725 CB56 00                    DC B:0                         	;HT       (Control-I)
0726 CB57 CB                    DC B:X_LF-1>>8                 	;LF       (Control-J)
0727 CB58 4C                    DC B:X_VT-$8001>>8             ;VT       (Control-K)
0728 CB59 4C                    DC B:X_FF-$8001>>8             ;FF       (Control-L)
0729 CB5A CA                    DC B:X_CR-1>>8                 	;CR	(Control-M)
0730 CB5B 4B                    DC B:X_SO-$8001>>8             ;SO	(Control-N)
0731 CB5C 4B                    DC B:X_SI-$8001>>8             ;SI	(Control-O)
0732 CB5D 00                    DC B:0                         	;DLE	(Control-P)
0733 CB5E 4C                    DC B:X_DC1-$8001>>8            ;DC1	(Control-Q)
0734 CB5F 4C                    DC B:X_DC2-$8001>>8            ;DC2	(Control-R)
0735 CB60 00                    DC B:0                         	;DC3      (Control-S)
0736 CB61 00                    DC B:0                         	;DC4      (Control-T)
0737 CB62 4C                    DC B:X_NAK-$8001>>8            ;NAK	(Control-U)
0738 CB63 4B                    DC B:SCROLLDN-$8001>>8         ;SYN	(Control-V)
0739 CB64 4B                    DC B:SCROLLUP-$8001>>8         ;ETB	(Control-W)
0740 CB65 4C                    DC B:MOUSEOFF-$8001>>8         ;CAN	(Control-X)
0741 CB66 4A                    DC B:X_EM-$8001>>8             ;EM       (Control-Y)
0742 CB67 4C                    DC B:X_SUB-$8001>>8            ;SUB	(Control-Z)
0743 CB68 4C                    DC B:MOUSEON-$8001>>8          ;	(Control-[)
0744 CB69 4A                    DC B:X_FS-$8001>>8             ;FS       (Control-\)
0745 CB6A 4C                    DC B:X_GS-$8001>>8             ;GS       (Control-Shift-M or Control-])
0746 CB6B CB                    DC B:X_CHCUR>>8                ;RS       (Control-^)
0747 CB6C 4B                    DC B:X_US-$8001>>8             ;US       (Control-_)
0748 CB6D
0749 CB6D
0750 CB6D                       EJECT 
0751 CB6D              * SCROLLIT scrolls the screen either up or down, depending
0752 CB6D              * on the value of X.  It scrolls within windows with even 
0753 CB6D              * or odd edges for both 40 and 80 columns.  It can scroll
0754 CB6D              * windows down to 1 characters wide.
0755 CB6D
0756 CB6D A0 00        SCROLLDN LDY   #0                       ;direction = down
0757 CB6F F0 15                 BEQ   SCROLLIT                 ;=>go do scroll
0758 CB71
0759 CB71              * EXECUTE LINEFEED:
0760 CB71
0761 CB71              X_LF     EQU   *
0762 CB71 E6 25                 INC   CV
0763 CB73 A5 25                 LDA   CV                       ;SEE IF OFF BOTTOM
0764 CB75 8D FB 05              STA   OURCV
0765 CB78 C5 23                 CMP   WNDBTM                   ;OFF THE END?
0766 CB7A B0 03                 BCS   @1                       ;=>yes, scroll screen 
0767 CB7C 4C 9C CD              JMP   VTABCZ                   ;exit thru VTABCZ
0768 CB7F
0769 CB7F              @1       EQU   *
0770 CB7F CE FB 05              DEC   OURCV                    ;back up to bottom
0771 CB82 C6 25                 DEC   CV                       ;and fall into scroll 
0772 CB84
0773 CB84 A0 01        SCROLLUP LDY   #1                       ;direction = up
0774 CB86
0775 CB86              SCROLLIT EQU   *
0776 CB86 AD 36 C0              LDA   CYAREG                   ;Save system speed
0777 CB89 48                    PHA                            ;
0778 CB8A 09 80                 ORA   #$80                     ; then go to hi speed mode for scroll
0779 CB8C 8D 36 C0              STA   CYAREG                   ;
0780 CB8F 20 97 CB              JSR   @1                       ;Do regular scroll routines
0781 CB92 68                    PLA                            ; then restore user speed
0782 CB93 8D 36 C0              STA   CYAREG                   ;
0783 CB96 60                    RTS                            ;Back to caller
0784 CB97
0785 CB97              @1       EQU   *
0786 CB97 DA                    PHX                            ;Save 'X'
0787 CB98 8C 7B 07              STY   TEMP1                    ;save direction
0788 CB9B A5 21                 LDA   WNDWDTH                  ;get width of screen window
0789 CB9D 48                    PHA                            ;save original width
0790 CB9E 2C 1F C0              BIT   RD80VID                  ;in 40 or 80 columns?
0791 CBA1 10 1B                 BPL   @4                       ;=>40, determine starting line
0792 CBA3 8D 01 C0              STA   SET80COL                 ;make sure this is enabled
0793 CBA6 4A                    LSR   A                        ;divide by 2 for 80 column index
0794 CBA7 AA                    TAX                            ;and save
0795 CBA8 A5 20                 LDA   WNDLFT                   ;test oddity of right edge
0796 CBAA 4A                    LSR   A                        ;by rotating low bit into carry
0797 CBAB B8                    CLV                            ;V=0 if left edge even
0798 CBAC 90 02                 BCC   @2                       ;=>check right edge
0799 CBAE E2 40                 SEP   #$40                     ;V=1 if left edge odd
0800 CBB0 2A           @2       ROL   A                        ;restore WNDLFT
0801 CBB1 45 21                 EOR   WNDWDTH                  ;get oddity of right edge
0802 CBB3 4A                    LSR   A                        ;C=1 if right edge even 
0803 CBB4 70 03                 BVS   @3                       ;if odd left, don't DEY
0804 CBB6 B0 01                 BCS   @3                       ;if even right, don't DEY
0805 CBB8 CA                    DEX                            ;if right edge odd, need one less
0806 CBB9 86 21        @3       STX   WNDWDTH                  ;save window width
0807 CBBB AD 1F C0              LDA   RD80VID                  ;N=1 if 80 columns
0808 CBBE 08           @4       PHP                            ;save N,Z,V
0809 CBBF A6 22                 LDX   WNDTOP                   ;assume scroll from top
0810 CBC1 98                    TYA                            ;up or down?
0811 CBC2 D0 03                 BNE   @5                       ;=>up
0812 CBC4 A6 23                 LDX   WNDBTM                   ;down, start scrolling at bottom
0813 CBC6 CA                    DEX                            ;really need one less
0814 CBC7
0815 CBC7 8A           @5       TXA                            ;get current line
0816 CBC8 20 9C CD              JSR   VTABCZ                   ;calculate base with window width
0817 CBCB
0818 CBCB A5 28        @6       LDA   BASL                     ;current line is destination  
0819 CBCD 85 2A                 STA   BAS2L
0820 CBCF A5 29                 LDA   BASH
0821 CBD1 85 2B                 STA   BAS2H
0822 CBD3
0823 CBD3 AD 7B 07              LDA   TEMP1                    ;test direction
0824 CBD6 F0 32                 BEQ   @44                      ;=>do the downer
0825 CBD8 E8                    INX                            ;do next line
0826 CBD9 E4 23                 CPX   WNDBTM                   ;done yet?
0827 CBDB B0 32                 BCS   @55                      ;=>yup, all done
0828 CBDD 8A           @7       TXA                            ;set new line
0829 CBDE 20 9C CD              JSR   VTABCZ                   ;get base for new current line
0830 CBE1 A4 21                 LDY   WNDWDTH                  ;get width for scroll 
0831 CBE3 28                    PLP                            ;get status for scroll
0832 CBE4 08                    PHP                            ;N=1 if 80 columns 
0833 CBE5 10 1E                 BPL   @8                       ;=>only do 40 columns
0834 CBE7 AD 55 C0              LDA   TXTPAGE2                 ;scroll aux page first (even bytes)
0835 CBEA 98                    TYA                            ;test Y
0836 CBEB F0 07                 BEQ   @11                      ;if Y=0, only scroll one byte
0837 CBED B1 28        @9       LDA   (BASL),Y
0838 CBEF 91 2A                 STA   (BAS2L),Y
0839 CBF1 88                    DEY   
0840 CBF2 D0 F9                 BNE   @9                       ;do all but last even byte
0841 CBF4 70 04        @11      BVS   @22                      ;odd left edge, skip this byte 
0842 CBF6 B1 28                 LDA   (BASL),Y
0843 CBF8 91 2A                 STA   (BAS2L),Y
0844 CBFA AD 54 C0     @22      LDA   TXTPAGE1                 ;now do main page (odd bytes)
0845 CBFD A4 21                 LDY   WNDWDTH                  ;restore width 
0846 CBFF B0 04                 BCS   @8                       ;even right edge, skip this byte
0847 CC01 B1 28        @33      LDA   (BASL),Y
0848 CC03 91 2A                 STA   (BAS2L),Y
0849 CC05 88           @8       DEY   
0850 CC06 10 F9                 BPL   @33
0851 CC08 30 C1                 BMI   @6                       ;=> always scroll next line
0852 CC0A
0853 CC0A CA           @44      DEX                            ;do next line
0854 CC0B E4 22                 CPX   WNDTOP                   ;done yet
0855 CC0D 10 CE                 BPL   @7                       ;=>nope, not yet
0856 CC0F
0857 CC0F 28           @55      PLP                            ;pull status off stack
0858 CC10 68                    PLA                            ;restore window width
0859 CC11 85 21                 STA   WNDWDTH
0860 CC13 20 3C CC              JSR   X_SUB                    ;clear current line
0861 CC16 20 97 CD              JSR   VTABC                    ;restore original cursor line
0862 CC19 FA                    PLX                            ;and X
0863 CC1A 60                    RTS                            ;done!!!
0864 CC1B
0865 CC1B              * EXECUTE CLR TO EOS:
0866 CC1B
0867 CC1B 20 40 CC     X_VT     JSR   X_GS                     ;CLEAR TO EOL
0868 CC1E A5 25                 LDA   CV                       ;SAVE CV
0869 CC20 48                    PHA   
0870 CC21 10 06                 BPL   @1                       ;DO NEXT LINE (ALWAYS TAKEN) 
0871 CC23 20 9C CD     @2       JSR   VTABCZ                   ;set base address 
0872 CC26 20 3C CC              JSR   X_SUB                    ;CLEAR LINE
0873 CC29 E6 25        @1       INC   CV
0874 CC2B A5 25                 LDA   CV
0875 CC2D C5 23                 CMP   WNDBTM                   ;OFF SCREEN?
0876 CC2F 90 F2                 BCC   @2                       ;=>NO, KEEP GOING
0877 CC31 68                    PLA                            ;RESTORE
0878 CC32 85 25                 STA   CV                       ; CV
0879 CC34 4C 97 CD              JMP   VTABC                    ;return via VTABC (blech)
0880 CC37
0881 CC37              * EXECUTE CLEAR:
0882 CC37
0883 CC37              X_FF     EQU   *
0884 CC37 20 F3 CA              JSR   X_EM                     ;HOME THE CURSOR
0885 CC3A 80 DF                 BRA   X_VT                     ;RETURN VIA CLREOS (UGH!) 
0886 CC3C
0887 CC3C              * EXECUTE CLEAR LINE
0888 CC3C
0889 CC3C A0 00        X_SUB    LDY   #0                       ;start at left
0890 CC3E F0 03                 BEQ   X_GSEOLZ                 ;and clear to end of line
0891 CC40
0892 CC40              * EXECUTE CLEAR TO EOL:
0893 CC40
0894 CC40 AC 7B 05     X_GS     LDY   OURCH                    ;get CH
0895 CC43 A5 32        X_GSEOLZ LDA   INVFLG                   ;mask blank
0896 CC45 29 80                 AND   #$80                     ;with high bit of invflg
0897 CC47 09 20                 ORA   #$20                     ;make it a blank
0898 CC49 2C 1F C0              BIT   RD80VID                  ;is it 80 columns?
0899 CC4C 30 13                 BMI   CLR80                    ;=>yes do quick clear
0900 CC4E 91 28        CLR40    STA   (BASL),Y
0901 CC50 C8                    INY   
0902 CC51 C4 21                 CPY   WNDWDTH
0903 CC53 90 F9                 BCC   CLR40
0904 CC55 60                    RTS   
0905 CC56
0906 CC56              * Clear right half of screen for 40 to 80
0907 CC56              * screen conversion
0908 CC56
0909 CC56 DA           CLRHALF  PHX                            ;save X
0910 CC57 A2 D8                 LDX   #$D8                     ;set horizontal counter
0911 CC59 A0 14                 LDY   #20
0912 CC5B A5 32                 LDA   INVFLG                   ;set (inverse) blank
0913 CC5D 29 A0                 AND   #$A0
0914 CC5F 80 17                 BRA   CLR2
0915 CC61
0916 CC61              * Clear to end of line for 80 columns
0917 CC61
0918 CC61 DA           CLR80    PHX                            ;save X
0919 CC62 48                    PHA                            ;and blank
0920 CC63 98                    TYA                            ;get count for CH
0921 CC64 48                    PHA                            ;save for left edge check
0922 CC65 38                    SEC                            ;count=WNDWDTH-Y-1
0923 CC66 E5 21                 SBC   WNDWDTH
0924 CC68 AA                    TAX                            ;save CH counter
0925 CC69 98                    TYA                            ;div CH by 2 for half pages
0926 CC6A 4A                    LSR   A
0927 CC6B A8                    TAY   
0928 CC6C 68                    PLA                            ;restore original ch
0929 CC6D 45 20                 EOR   WNDLFT                   ;get starting page
0930 CC6F 6A                    ROR   A
0931 CC70 B0 03                 BCS   @1
0932 CC72 10 01                 BPL   @1
0933 CC74 C8                    INY                            ;if WNDLFT odd, starting byte odd
0934 CC75 68           @1       PLA                            ;get blank
0935 CC76 B0 0B                 BCS   CLR1                     ;starting page is 1 (default)
0936 CC78 2C 55 C0     CLR2     BIT   TXTPAGE2                 ;else do page 2
0937 CC7B 91 28                 STA   (BASL),Y
0938 CC7D 2C 54 C0              BIT   TXTPAGE1                 ;now do page 1
0939 CC80 E8                    INX   
0940 CC81 F0 06                 BEQ   CLR3                     ;all done
0941 CC83 91 28        CLR1     STA   (BASL),Y
0942 CC85 C8                    INY                            ;forward 2 columns
0943 CC86 E8                    INX                            ;next ch
0944 CC87 D0 EF                 BNE   CLR2                     ;not done yet
0945 CC89 FA           CLR3     PLX                            ;restore X
0946 CC8A 38                    SEC                            ;good exit condition
0947 CC8B 60                    RTS                            ;and return
0948 CC8C
0949 CC8C              * EXECUTE '40COL MODE':
0950 CC8C
0951 CC8C              X_DC1    EQU   *
0952 CC8C AD FB 04              LDA   MODE                     ;don't convert if Pascal
0953 CC8F 30 48                 BMI   X_DC1RTS                 ;=>it's Pascal
0954 CC91 20 CE CC     X_DC1A   JSR   SETTOP                   ;set top of window (0 or 20)
0955 CC94 2C 1F C0              BIT   RD80VID                  ;are we in 80 columns?
0956 CC97 10 0D                 BPL   X_DC1B                   ;=>no, no convert needed
0957 CC99 20 2E CD              JSR   SCRN84                   ;else convert 80 to 40
0958 CC9C 90 08                 BCC   X_DC1B                   ;=>always set new window
0959 CC9E
0960 CC9E              * Set 80 column mode
0961 CC9E
0962 CC9E              X_DC2    EQU   *
0963 CC9E 2C 1F C0              BIT   RD80VID                  ;are we in 40 columns?
0964 CCA1 30 03                 BMI   X_DC1B                   ;=>no, no convert needed
0965 CCA3 20 5F CD              JSR   SCRN48                   ;else convert 40 to 80
0966 CCA6
0967 CCA6 AD 7B 05     X_DC1B   LDA   OURCH                    ;get cursor
0968 CCA9 18                    CLC                            ;since new window left = 0
0969 CCAA 65 20                 ADC   WNDLFT                   ;NEWCH=OLDCH+OLDWNDLFT
0970 CCAC 2C 1F C0              BIT   RD80VID                  ;in 80 columns?
0971 CCAF 30 06                 BMI   @2                       ;=>yes, CH is ok
0972 CCB1 C9 28                 CMP   #40                      ;else if CH is too big,
0973 CCB3 90 02                 BCC   @2                       ;set it to 39
0974 CCB5 A9 27                 LDA   #39
0975 CCB7 8D 7B 05     @2       STA   OURCH                    ;save new CH
0976 CCBA 85 24                 STA   CH
0977 CCBC A5 25                 LDA   CV                       ;base
0978 CCBE 20 64 CA              JSR   BASCALCC
0979 CCC1 2C 1F C0              BIT   RD80VID                  ;in 80 columns?
0980 CCC4 10 05                 BPL   DO40                     ;=>no, set forty column window
0981 CCC6
0982 CCC6 20 0A CD              JSR   FULL80                   ;set 80 column window
0983 CCC9 80 03                 BRA   SETTOP                   ;=>always branch
0984 CCCB
0985 CCCB 20 06 CD     DO40     JSR   FULL40                   ;set 40 column window
0986 CCCE A9 00        SETTOP   LDA   #0                       ;assume normal window
0987 CCD0 2C 1A C0              BIT   RDTEXT                   ;text or mixed?
0988 CCD3 30 02                 BMI   @1                       ;=>text, all ok
0989 CCD5 A9 14                 LDA   #20
0990 CCD7 85 22        @1       STA   WNDTOP                   ;set new top
0991 CCD9 60           X_DC1RTS RTS   
0992 CCDA
0993 CCDA              * EXECUTE MOUSE TEXT OFF
0994 CCDA
0995 CCDA A9 01        MOUSEOFF LDA   #M_MOUSE                 ;Set mouse bit
0996 CCDC 0C FB 04              TSB   MODE                     ;
0997 CCDF 60                    RTS                            ;to disable mouse chars
0998 CCE0
0999 CCE0              * EXECUTE MOUSE TEXT ON
1000 CCE0
1001 CCE0 A9 01        MOUSEON  LDA   #M_MOUSE                 ;Reset mouse bit
1002 CCE2 1C FB 04              TRB   MODE                     ;
1003 CCE5 60                    RTS                            ;to enable mouse chars
1004 CCE6
1005 CCE6              * EXECUTE 'QUIT':
1006 CCE6
1007 CCE6              X_NAK    EQU   *
1008 CCE6 AD FB 04              LDA   MODE                     ;ONLY VALID IN BASIC
1009 CCE9 30 1A                 BMI   SKRTS                    ;ignore if pascal
1010 CCEB              X_NAK2   EQU   *
1011 CCEB 20 CB CC              JSR   DO40                     ;force 40 column window
1012 CCEE 20 19 CD              JSR   QUIT                     ;do stuff used by PR#0
1013 CCF1 20 FD CC              JSR   SETCOUT1                 ;set output hook
1014 CCF4
1015 CCF4 A9 FD        SETKEYIN LDA   #>KEYIN                  ;set input hook
1016 CCF6 85 39                 STA   KSWH
1017 CCF8 A9 1B                 LDA   #<KEYIN
1018 CCFA 85 38                 STA   KSWL
1019 CCFC 60                    RTS   
1020 CCFD
1021 CCFD A9 FD        SETCOUT1 LDA   #>COUT1                  ;set output hook
1022 CCFF 85 37                 STA   CSWH
1023 CD01 A9 F0                 LDA   #<COUT1
1024 CD03 85 36                 STA   CSWL
1025 CD05 60           SKRTS    RTS   
1026 CD06
1027 CD06              ****************************************
1028 CD06              * NAME    : FULL40
1029 CD06              * FUNCTION: SET FULL 40COL WINDOW
1030 CD06              * INPUT   : NONE
1031 CD06              * OUTPUT  : WINDOW PARAMETERS, A=0 
1032 CD06              * VOLATILE: AC
1033 CD06              ****************************************
1034 CD06
1035 CD06              FULL40   EQU   *
1036 CD06 A9 28                 LDA   #40                      ;set window width to 40
1037 CD08 D0 02                 BNE   SAVWDTH                  ;=>(always taken)
1038 CD0A
1039 CD0A              ****************************************
1040 CD0A              * NAME    : FULL80 
1041 CD0A              * FUNCTION: SET FULL 80COL WINDOW
1042 CD0A              * INPUT   : NONE
1043 CD0A              * OUTPUT  : WINDOW PARAMETERS, A=0 
1044 CD0A              * VOLATILE: AC
1045 CD0A              ****************************************
1046 CD0A
1047 CD0A A9 50        FULL80   LDA   #80                      ;set full 80 column window
1048 CD0C 85 21        SAVWDTH  STA   WNDWDTH
1049 CD0E A9 18                 LDA   #24
1050 CD10 85 23                 STA   WNDBTM
1051 CD12 64 22                 STZ   WNDTOP
1052 CD14 64 20                 STZ   WNDLFT
1053 CD16 A9 00                 LDA   #$00                     ;MUST exit with 'A'=0
1054 CD18 60                    RTS   
1055 CD19
1056 CD19              * QUIT is used by PR#0 to turn off everything
1057 CD19
1058 CD19              QUIT     EQU   *
1059 CD19 2C 1F C0              BIT   RD80VID                  ;were we in 80 columns?
1060 CD1C 10 03                 BPL   QUIT2                    ;=> not a chance
1061 CD1E 20 91 CC              JSR   X_DC1A                   ;switch to 40 columns
1062 CD21 8D 0E C0     QUIT2    STA   CLRALTCHAR               ;don't use lower case 
1063 CD24 A9 FF                 LDA   #$FF                     ;DESTROY THE
1064 CD26 8D FB 04              STA   MODE                     ; MODE BYTE
1065 CD29 8F 35 01 E1           STA   >CURSOR                  ;Set checkerboard cursor
1066 CD2D 60                    RTS   
1067 CD2E
1068 CD2E              * SCRN84 and SCRN48 convert screens between 40 & 80 cols.
1069 CD2E              * WNDTOP must be set up to indicate the last line to
1070 CD2E              * be done.  All registers are trashed.
1071 CD2E
1072 CD2E              SCRN84   EQU   *
1073 CD2E DA                    PHX                            ;Save 'X'
1074 CD2F A2 17                 LDX   #23                      ;start at bottom of screen
1075 CD31 8D 01 C0              STA   SET80COL                 ;allow page 2 access
1076 CD34 8A           @1       TXA                            ;calc base for line
1077 CD35 20 64 CA              JSR   BASCALCC
1078 CD38 A0 27                 LDY   #39                      ;start at right of screen
1079 CD3A 84 2A        @2       STY   BAS2L                    ;save 40 index
1080 CD3C 98                    TYA                            ;div by 2 for 80 column index
1081 CD3D 4A                    LSR   A
1082 CD3E B0 03                 BCS   @3
1083 CD40 2C 55 C0              BIT   TXTPAGE2                 ;even column, do page 2
1084 CD43 A8           @3       TAY                            ;get 80 index
1085 CD44 B1 28                 LDA   (BASL),Y                 ;get 80 char 
1086 CD46 2C 54 C0              BIT   TXTPAGE1                 ;restore page1
1087 CD49 A4 2A                 LDY   BAS2L                    ;get 40 index
1088 CD4B 91 28                 STA   (BASL),Y
1089 CD4D 88                    DEY   
1090 CD4E 10 EA                 BPL   @2                       ;do next 40 byte
1091 CD50 CA                    DEX                            ;do next line
1092 CD51 30 04                 BMI   @4                       ;=>done with setup
1093 CD53 E4 22                 CPX   WNDTOP                   ;at top yet? 
1094 CD55 B0 DD                 BCS   @1
1095 CD57 8D 00 C0     @4       STA   CLR80COL                 ;clear 80STORE for 40 columns
1096 CD5A 8D 0C C0              STA   CLR80VID                 ;clear 80VID for 40 columns
1097 CD5D 80 33                 BRA   SCRNRET                  ;calc base, restore X, exit
1098 CD5F
1099 CD5F              SCRN48   EQU   *                        ;
1100 CD5F DA                    PHX                            ;Save X
1101 CD60 A2 17                 LDX   #23                      ;start at bottom of screen
1102 CD62 8A           @5       TXA                            ;set base for current line
1103 CD63 20 64 CA              JSR   BASCALCC
1104 CD66 A0 00                 LDY   #0                       ;start at left of screen
1105 CD68 8D 01 C0              STA   SET80COL                 ;enable page2 store
1106 CD6B B1 28        @6       LDA   (BASL),Y                 ;get 40 column char
1107 CD6D 84 2A                 STY   BAS2L                    ;save 40 column index
1108 CD6F 48                    PHA                            ;save char
1109 CD70 98                    TYA                            ;div 2 for 80 column index
1110 CD71 4A                    LSR   A
1111 CD72 B0 03                 BCS   @7                       ;save on page1
1112 CD74 8D 55 C0              STA   TXTPAGE2
1113 CD77 A8           @7       TAY                            ;get 80 column index
1114 CD78 68                    PLA                            ;now save character
1115 CD79 91 28                 STA   (BASL),Y
1116 CD7B 8D 54 C0              STA   TXTPAGE1                 ;flip page1
1117 CD7E A4 2A                 LDY   BAS2L                    ;restore 40 column index
1118 CD80 C8                    INY                            ;move to the right
1119 CD81 C0 28                 CPY   #40                      ;at right yet?
1120 CD83 90 E6                 BCC   @6                       ;=>no, do next column
1121 CD85 20 56 CC              JSR   CLRHALF                  ;clear half of screen
1122 CD88 CA                    DEX                            ;else do next line of screen
1123 CD89 30 04                 BMI   @9                       ;=>done with top line
1124 CD8B E4 22                 CPX   WNDTOP                   ;at top yet?
1125 CD8D B0 D3                 BCS   @5
1126 CD8F 8D 0D C0     @9       STA   SET80VID                 ;convert to 80 columns
1127 CD92 20 97 CD     SCRNRET  JSR   VTABC                    ;update base
1128 CD95 FA                    PLX                            ;restore X
1129 CD96 60                    RTS   
1130 CD97
1131 CD97 A5 25        VTABC    LDA   CV                       ;get 80 column CV
1132 CD99 8D FB 05              STA   OURCV                    ;copy to OURCV
1133 CD9C 20 64 CA     VTABCZ   JSR   BASCALCC                 ;calc base address
1134 CD9F A5 20                 LDA   WNDLFT                   ;and add window left to it
1135 CDA1 2C 1F C0              BIT   RD80VID                  ;is it 80 columns?
1136 CDA4 10 01                 BPL   @1                       ;window width ok
1137 CDA6 4A                    LSR   A                        ;else divide width by 2
1138 CDA7 18           @1       CLC                            ;prepare to add
1139 CDA8 65 28                 ADC   BASL                     ;add in window left
1140 CDAA 85 28                 STA   BASL                     ;and update base
1141 CDAC 60                    RTS                            ;and exit
1142 CDAD                       EJECT 
1143 CDAD C9 E1        UPSHFT   CMP   #$E1                     ;is it lowercase?
1144 CDAF 90 06                 BCC   @2                       ;=>nope
1145 CDB1 C9 FB                 CMP   #$FB                     ;lowercase?
1146 CDB3 B0 02                 BCS   @2                       ;=>nope
1147 CDB5 29 DF                 AND   #$DF                     ;else upshift
1148 CDB7 60           @2       RTS   
1149 CDB8
1150 CDB8              ****************************************
1151 CDB8              * NAME    : PICKY
1152 CDB8              * FUNCTION: GET A CHAR FROM SCREEN
1153 CDB8              * INPUT   : Y=CH POSITION 
1154 CDB8              * OUTPUT  : AC=CHARACTER
1155 CDB8              * VOLATILE: NOTHING
1156 CDB8              * CALLS   : SCREENIT 
1157 CDB8              ****************************************
1158 CDB8
1159 CDB8              PICKY    EQU   *
1160 CDB8 5A                    PHY                            ;Save 'Y' register value
1161 CDB9 20 78 C9              JSR   GETCUR                   ;Get newest cursor into 'Y'
1162 CDBC A5                    OPCODE.zpg LDA                 ;Skip next PHY
1163 CDBD
1164 CDBD              PPICKY   EQU   *
1165 CDBD 5A                    PHY                            ;Save 'Y' register value
1166 CDBE              PPICKY2  EQU   *
1167 CDBE B1 28                 LDA   (BASL),Y                 ;get 40 column character
1168 CDC0 2C 1F C0              BIT   RD80VID                  ;80 columns?
1169 CDC3 10 15                 BPL   @3                       ;=>no, do text shift 
1170 CDC5 8D 01 C0              STA   SET80COL                 ;force 80STORE for 80 columns 
1171 CDC8 98                    TYA                            ;divide CH by two
1172 CDC9 45 20                 EOR   WNDLFT                   ;C=1 if char in main RAM
1173 CDCB 6A                    ROR   A                        ;get low bit into carry
1174 CDCC B0 04                 BCS   @1                       ;=>store in main memory
1175 CDCE AD 55 C0              LDA   TXTPAGE2                 ;else switch in page 2
1176 CDD1 C8                    INY                            ;for odd left, aux bytes
1177 CDD2 98           @1       TYA                            ;divide position by 2
1178 CDD3 4A                    LSR   A                        ;and use carry as
1179 CDD4 A8                    TAY                            ;page indicator
1180 CDD5 B1 28                 LDA   (BASL),Y                 ;get that char
1181 CDD7 2C 54 C0              BIT   TXTPAGE1                 ;flip to page 1
1182 CDDA 2C 1E C0     @3       BIT   ALTCHARSET               ;only allow mouse text
1183 CDDD 10 06                 BPL   @4                       ;if alternate character set
1184 CDDF C9 20                 CMP   #$20
1185 CDE1 B0 02                 BCS   @4
1186 CDE3 09 40                 ORA   #$40
1187 CDE5              @4       EQU   *
1188 CDE5 7A                    PLY                            ;Restore entry 'Y' value
1189 CDE6 60                    RTS   
1190 CDE7
1191 CDE7              ****************************************
1192 CDE7              * NAME    : STORCH
1193 CDE7              * FUNCTION: STORE A CHAR ON SCREEN
1194 CDE7              * INPUT   : AC=CHAR 
1195 CDE7              *         :  Y=CH POSITION
1196 CDE7              * OUTPUT  : CHAR ON SCREEN
1197 CDE7              * VOLATILE: NOTHING
1198 CDE7              * CALLS   : Exits into STOR2
1199 CDE7              ****************************************
1200 CDE7
1201 CDE7              STORCH   EQU   *
1202 CDE7 48                    PHA                            ;Save 'A'
1203 CDE8 20 ED CD              JSR   @1                       ;Come back to here to restore 'A'
1204 CDEB 68                    PLA                            ;
1205 CDEC 60                    RTS                            ; then go back to caller.
1206 CDED
1207 CDED              @1       EQU   *
1208 CDED 24 32                 BIT   INVFLG                   ;NORMAL OR INVERSE?
1209 CDEF 30 02                 BMI   STORY                    ;=>NORMAL
1210 CDF1 29 7F                 AND   #$7F                     ;inverse it
1211 CDF3
1212 CDF3              ****************************************
1213 CDF3              * NAME    : STORY 
1214 CDF3              * FUNCTION: STORE CHAR
1215 CDF3              * INPUT   : AC=char for store
1216 CDF3              *         :  Z=high bit of char
1217 CDF3              *         :  Y=CH POSITION
1218 CDF3              * OUTPUT  : AC=CHAR (PICK) 
1219 CDF3              * VOLATILE: NOTHING 
1220 CDF3              * CALLS   : NOTHING 
1221 CDF3              ****************************************
1222 CDF3
1223 CDF3              STORY    EQU   *
1224 CDF3 48                    PHA                            ;Save character
1225 CDF4 20 78 C9              JSR   GETCUR                   ;Put newest cursor pstn into 'Y'
1226 CDF7 80 01                 BRA   PSTORY2                  ;Skip PHA
1227 CDF9
1228 CDF9              PSTORY   EQU   *
1229 CDF9 48                    PHA                            ;save char 
1230 CDFA              PSTORY2  EQU   *
1231 CDFA 29 FF                 AND   #$FF                     ;if high bit set... 
1232 CDFC 30 15                 BMI   @1                       ;=>not mouse text
1233 CDFE AD FB 04              LDA   MODE                     ;is mouse text enabled?
1234 CE01 6A                    ROR   A                        ;use carry as flag
1235 CE02 68                    PLA                            ;and restore char
1236 CE03 48                    PHA                            ;need to save it too
1237 CE04 90 0D                 BCC   @1
1238 CE06 2C 1E C0              BIT   ALTCHARSET               ;only do mouse text if
1239 CE09 10 08                 BPL   @1                       ;alt char set switched in
1240 CE0B 49 40                 EOR   #$40                     ;do mouse shift
1241 CE0D 89 60                 BIT   #$60                     ;is it in proper range?
1242 CE0F F0 02                 BEQ   @1                       ;=>yes, leave it 
1243 CE11 49 40                 EOR   #$40                     ;else shift it back 
1244 CE13
1245 CE13 2C 1F C0     @1       BIT   RD80VID                  ;80 columns?
1246 CE16 10 1B                 BPL   @3                       ;=>no, 40 columns
1247 CE18 8D 01 C0              STA   SET80COL                 ;force 80STORE for 80 columns
1248 CE1B 5A                    PHY                            ;Save 'Y' value
1249 CE1C 48                    PHA                            ;save shifted character
1250 CE1D 98                    TYA                            ;get position  
1251 CE1E 45 20                 EOR   WNDLFT                   ;C=1 if char in main RAM
1252 CE20 4A                    LSR   A
1253 CE21 B0 04                 BCS   @2                       ;=>yes, main RAM
1254 CE23 AD 55 C0              LDA   TXTPAGE2                 ;else flip in main RAM
1255 CE26 C8                    INY                            ;do this for odd left bytes
1256 CE27 98           @2       TYA                            ;get position
1257 CE28 4A                    LSR   A                        ;and divide it by 2
1258 CE29 A8                    TAY   
1259 CE2A 68                    PLA                            ;restore acc
1260 CE2B 91 28                 STA   (BASL),Y                 ;save to screen
1261 CE2D AD 54 C0              LDA   TXTPAGE1                 ;flip to page 1
1262 CE30 7A                    PLY                            ;Restore 'Y' value
1263 CE31 68                    PLA                            ;restore true Acc
1264 CE32 60                    RTS                            ;and exit
1265 CE33
1266 CE33 91 28        @3       STA   (BASL),Y                 ;quick 40 column store
1267 CE35 68                    PLA                            ;restore real char
1268 CE36 60                    RTS   
1269 CE37
1270 CE37              ****************************************
1271 CE37              * NAME    : ESCON
1272 CE37              * FUNCTION: TURN ON 'ESCAPE' CURSOR
1273 CE37              * INPUT   : NONE
1274 CE37              * OUTPUT  : 'CHAR'=ORIGINAL CHAR 
1275 CE37              * VOLATELE: NOTHING
1276 CE37              * CALLS   : PICK,STORCHAR
1277 CE37              ****************************************
1278 CE37
1279 CE37              ESCON    EQU   *
1280 CE37 5A                    PHY                            ; AND Y
1281 CE38 48                    PHA                            ;SAVE AC
1282 CE39 20 B8 CD              JSR   PICKY                    ;GET ORIGINAL CHARACTER
1283 CE3C 8D 7B 06              STA   CHAR                     ; AND REMEMBER FOR ESCOFF
1284 CE3F 29 80                 AND   #$80                     ;SAVE NORMAL/INVERSE BIT
1285 CE41 49 AB                 EOR   #$AB                     ;MAKE IT AN INVERSE '+'
1286 CE43              ESCON2   EQU   *
1287 CE43 20 F3 CD              JSR   STORY                    ; ONTO SCREEN
1288 CE46              ESCON4   EQU   *
1289 CE46 68                    PLA                            ; AND A
1290 CE47 7A                    PLY                            ;RESTORE Y
1291 CE48              ESCON6   EQU   *
1292 CE48 60                    RTS   
1293 CE49
1294 CE49              ****************************************
1295 CE49              * NAME    : ESCOFF
1296 CE49              * FUNCTION: TURN OFF 'ESCAPE' CURSOR
1297 CE49              * INPUT   : 'CHAR'=ORIGINAL CHAR
1298 CE49              * OUTPUT  : NONE
1299 CE49              * VOLATILE: NOTHING
1300 CE49              * CALLS   : STORCHAR
1301 CE49              ****************************************
1302 CE49
1303 CE49              ESCOFF   EQU   *
1304 CE49 5A                    PHY                            ; AND Y
1305 CE4A 48                    PHA                            ;SAVE AC
1306 CE4B AC 7B 05              LDY   OURCH                    ;GET CH 
1307 CE4E AD 7B 06              LDA   CHAR                     ;GET ORIGINAL CHARACTER
1308 CE51 80 F0                 BRA   ESCON2                   ;Exit this way
1309 CE53
1310 CE53              ****************************************
1311 CE53              * NAME    : INVERT
1312 CE53              * FUNCTION: INVERT CHAR AT CH/CV
1313 CE53              *         : Unless Pascal and M_CURSOR=1
1314 CE53              * INPUT   : NOTHING
1315 CE53              * OUTPUT  : CHAR AT CH/CV INVERTED
1316 CE53              * VOLATILE: NOTHING
1317 CE53              * CALLS   : PICK, STORCHAR 
1318 CE53              ****************************************
1319 CE53
1320 CE53 AD FB 04     PASINV   LDA   MODE                     ;check pascal cursor flag
1321 CE56 29 10                 AND   #M_CURSOR                ;before displaying cursor
1322 CE58 D0 EE                 BNE   ESCON6                   ;=>cursor off, don't invert
1323 CE5A 5A                    PHY                            ; AND Y
1324 CE5B 48                    PHA                            ;save AC
1325 CE5C AC 7B 05              LDY   OURCH                    ;Get cursor position to 'pick' from
1326 CE5F 20 BD CD              JSR   PPICKY                   ;GET CHARACTER
1327 CE62 49 80                 EOR   #$80                     ;FLIP INVERSE/NORMAL
1328 CE64 20 F9 CD              JSR   PSTORY                   ; ONTO SCREEN
1329 CE67 80 DD                 BRA   ESCON4                   ;Exit this way to save a byte
1330 CE69
1331 CE69              ****************************************
1332 CE69              * NAME    : PSETUP
1333 CE69              * FUNCTION: SETUP ZP FOR PASCAL
1334 CE69              * INPUT   : NONE
1335 CE69              * OUTPUT  : NONE
1336 CE69              * VOLATILE: AC
1337 CE69              * CALLS   : NOTHING
1338 CE69              ****************************************
1339 CE69
1340 CE69              PSETUP   EQU   *
1341 CE69 20 0A CD              JSR   FULL80                   ;SET FULL 80COL WINDOW
1342 CE6C A9 FF                 LDA   #255
1343 CE6E 85 32                 STA   INVFLG                   ;ASSUME NORMAL MODE
1344 CE70
1345 CE70 AD FB 04              LDA   MODE
1346 CE73 29 04                 AND   #M_VMODE
1347 CE75 F0 02                 BEQ   @1                       ;=>IT'S NORMAL
1348 CE77 46 32                 LSR   INVFLG                   ;MAKE IT INVERSE
1349 CE79
1350 CE79              @1       EQU   *
1351 CE79 AD 7B 07              LDA   OLDBASL                  ;SET UP BASE ADDRESS
1352 CE7C 85 28                 STA   BASL
1353 CE7E AD FB 07              LDA   OLDBASH
1354 CE81 85 29                 STA   BASH
1355 CE83 AD FB 05              LDA   OURCV                    ;get user's cursor vertical
1356 CE86 85 25                 STA   CV                       ;and set it up
1357 CE88 60                    RTS   
1358 CE89
1359 CE89              ****************************************
1360 CE89              *
1361 CE89              * COPYROM is called when the video firmware is 
1362 CE89              * initialized.  If the language card is switched
1363 CE89              * in for reading, it copies the F8 ROM to the 
1364 CE89              * language card and restores the state of the    
1365 CE89              * language card.
1366 CE89              *
1367 CE89              ****************************************
1368 CE89
1369 CE89 2C 12 C0     COPYROM  BIT   RDLCRAM                  ;is the LC switched in?
1370 CE8C 10 3A                 BPL   @22                      ;=>no, do nothing
1371 CE8E A9 06                 LDA   #GOODF8                  ;yes, check $F8 RAM
1372 CE90 C5 06                 CMP   F8VERSION                ;does it match?
1373 CE92 F0 34                 BEQ   @22                      ;=> assum ROM is there
1374 CE94 A2 03                 LDX   #3                       ;indicate bank 2, RAM write enabled
1375 CE96 2C 11 C0              BIT   RDLCBNK2                 ;is it bank 2?
1376 CE99 30 02                 BMI   @1                       ;=>yes, we were right
1377 CE9B A2 0B                 LDX   #$B                      ;no, bank 1, RAM write enabled
1378 CE9D 85 06        @1       STA   F8VERSION                ;write to see if LC is
1379 CE9F 2C 80 C0              BIT   $C080                    ;write protected (read RAM)
1380 CEA2 A5 06                 LDA   F8VERSION                ;did it change?
1381 CEA4 C9 06                 CMP   #GOODF8
1382 CEA6 F0 01                 BEQ   @2                       ;=>yes, write enabled
1383 CEA8 E8                    INX                            ;else indicate write protect
1384 CEA9 2C 81 C0     @2       BIT   $C081                    ;read ROM, write RAM
1385 CEAC 2C 81 C0              BIT   $C081                    ;twice is nice
1386 CEAF A0 00                 LDY   #$0                      ;now copy ROM to RAM
1387 CEB1 A9 F8                 LDA   #$F8
1388 CEB3 85 37                 STA   CSWH                     ;hooks set later 
1389 CEB5 84 36                 STY   CSWL
1390 CEB7 B1 36        @11      LDA   (CSWL),Y                 ;get a byte
1391 CEB9 91 36                 STA   (CSWL),Y                 ;and move it
1392 CEBB C8                    INY   
1393 CEBC D0 F9                 BNE   @11
1394 CEBE E6 37                 INC   CSWH                     ;next page
1395 CEC0 D0 F5                 BNE   @11
1396 CEC2 BD 80 C0              LDA   $C080,X                  ;restore language card
1397 CEC5 BD 80 C0              LDA   $C080,X                  ;twice to cover all cases
1398 CEC8 60           @22      RTS                            ;and return
1399 CEC9
1400 CEC9
1401 CEC9                       EJECT 
1402 CEC9
1403 CEC9              * SHOWCUR displays either a checkerboard cursor, a solid 
1404 CEC9              * rectangle, or the current cursor character, depending
1405 CEC9              * on the value of the CURSOR location.  0=inverse cursor,
1406 CEC9              * $FF=checkerboard cursor, anything else is displayed 
1407 CEC9              * after being anded with inverse mask.
1408 CEC9
1409 CEC9              SHOWCUR  EQU   *                        ;what's my type?
1410 CEC9 48                    PHA                            ;Save 'A'
1411 CECA AF 35 01 E1           LDA   >CURSOR                  ;Get type
1412 CECE A8                    TAY                            ;'Y' needs to be cursor value
1413 CECF D0 0B                 BNE   SHOWCUR4                 ;=>not inverse
1414 CED1 68                    PLA                            ;Restore 'A'
1415 CED2              SHOWCUR2 EQU   *
1416 CED2 5A                    PHY                            ;Preserve 'Y' around call
1417 CED3 20 B8 CD              JSR   PICKY                    ;Get character
1418 CED6 48                    PHA                            ;Save character
1419 CED7 49 80                 EOR   #$80                     ;Flip inverse/normal
1420 CED9 4C 43 CE              JMP   ESCON2                   ;Exit via return routine
1421 CEDC
1422 CEDC              * Exit with char in accumulator
1423 CEDC
1424 CEDC              SHOWCUR4 EQU   *
1425 CEDC 68                    PLA                            ;Recall 'A'
1426 CEDD 20 B8 CD              JSR   PICKY                    ;get char on screen
1427 CEE0 48                    PHA                            ;preserve it
1428 CEE1 8F 36 01 E1           STA   >NXTCUR                  ;save for update
1429 CEE5 98                    TYA                            ;test for checkerboard
1430 CEE6 C8                    INY   
1431 CEE7 F0 0E                 BEQ   @2                       ;=>checkerboard, display it
1432 CEE9 7A                    PLY                            ;test char
1433 CEEA 5A                    PHY   
1434 CEEB 30 0A                 BMI   @2                       ;don't need inverse 
1435 CEED AD 1E C0              LDA   ALTCHARSET               ;mask = $7F if alternate
1436 CEF0 09 7F                 ORA   #$7F                     ; character set, 
1437 CEF2 4A                    LSR   A                        ;$3F if normal char set
1438 CEF3 2F 35 01 E1           AND   >CURSOR                  ;form char to display
1439 CEF7 20 F3 CD     @2       JSR   STORY                    ;and display it
1440 CEFA 68                    PLA                            ;restore real char
1441 CEFB 60                    RTS   
1442 CEFC
1443 CEFC              * The UPDATE routine increments the random seed.  
1444 CEFC              * If a certain value is reached and we are in Apple II
1445 CEFC              * mode, the blinking check cursor is updated.  If a
1446 CEFC              * key has been pressed, the old char is replaced on the
1447 CEFC              * screen, and we return with BMI.  
1448 CEFC
1449 CEFC              UPDATE   EQU   *
1450 CEFC EB                    XBA                            ;Save 'A' in 'B'
1451 CEFD AD 36 C0              LDA   CYAREG                   ;Always flash at 1 megahertz
1452 CF00 09 80                 ORA   #$80                     ;Shift to high speed
1453 CF02 48                    PHA                            ;Save place for 'P' status on stack
1454 CF03 48                    PHA                            ;Save speed on stack
1455 CF04 8D 36 C0              STA   CYAREG                   ;
1456 CF07 EB                    XBA                            ;Restore 'A' from 'B'
1457 CF08 48                    PHA                            ;save char
1458 CF09 E6 4E                 INC   RNDL                     ;update seed
1459 CF0B D0 2A                 BNE   @1                       ;check for key
1460 CF0D E6 4F                 INC   RNDH
1461 CF0F AF 45 01 E1           LDA   >CURSHIFTER              ;Do we or don't we flash cursor
1462 CF13 3A                    DEC   A                        ;Shift til = 0 then flash
1463 CF14 8F 45 01 E1           STA   >CURSHIFTER              ;
1464 CF18 10 1D                 BPL   @1                       ;
1465 CF1A 20 EA C3              JSR   FIXCURSHIFTER            ;Fix cursor flash rate
1466 CF1D AF 35 01 E1           LDA   >CURSOR                  ;what cursor are we using?
1467 CF21 F0 14                 BEQ   @1                       ;=>//e cursor, leave alone
1468 CF23 5A                    PHY                            ;+ Save Y
1469 CF24 20 B8 CD              JSR   PICKY                    ;get the character into A 
1470 CF27 48                    PHA                            ;Save 'A'
1471 CF28 AF 36 01 E1           LDA   >NXTCUR                  ;get next character
1472 CF2C A8                    TAY                            ;'Y' must contain NXTCUR
1473 CF2D 68                    PLA                            ;Restore 'A'
1474 CF2E 8F 36 01 E1           STA   >NXTCUR                  ;save next character
1475 CF32 98                    TYA   
1476 CF33 20 F3 CD              JSR   STORY                    ;and print it 
1477 CF36 7A                    PLY                            ;+
1478 CF37 68           @1       PLA                            ;get real char
1479 CF38 20 94 CF              JSR   XBITKBD                  ;was a key pressed?
1480 CF3B 08                    PHP                            ;Get result status
1481 CF3C 08                    PHP                            ;Get result status
1482 CF3D EB                    XBA                            ;Save 'A' in 'B'
1483 CF3E 68                    PLA                            ;Recall status
1484 CF3F 83 03                 STA   3,S                      ;Put in 'P' position on stack
1485 CF41 EB                    XBA                            ;Restore 'A'
1486 CF42 28                    PLP                            ;Restore 'n' status
1487 CF43 10 06                 BPL   @2                       ;=>no key pressed
1488 CF45
1489 CF45              *  + restore old key look for key and exit
1490 CF45
1491 CF45 20 F3 CD              JSR   STORY                    ;
1492 CF48 20 74 CF              JSR   XRDKBD                   ;
1493 CF4B              @2       EQU   *
1494 CF4B EB                    XBA                            ;Save 'A' in 'B'
1495 CF4C 68                    PLA                            ;Restore system speed
1496 CF4D 29 7F                 AND   #$7F                     ;Strip off speed bit
1497 CF4F 0F 38 01 E1           ORA   >SYSTEMSPD               ;Or in system speed mask
1498 CF53 8D 36 C0              STA   CYAREG                   ;
1499 CF56 EB                    XBA                            ;Restore keypress to 'A' from 'B'
1500 CF57 28                    PLP                            ;Restore 'n' status
1501 CF58 60                    RTS                            ;Back to caller
1502 CF59
1503 CF59
1504 CF59              * This routine is used by communications firmware. 
1505 CF59
1506 CF59              SETHOOKS EQU   *
1507 CF59 20 2A C8              JSR   C3HOOKS                  ;Set up $C3xx hooks
1508 CF5C A9 00                 LDA   #$00                     ;set a solid inverse cursor
1509 CF5E 8F 35 01 E1           STA   >CURSOR                  ;
1510 CF62 A9 F7                 LDA   #$FF-M_CTL               ;preserve M_CTL bit
1511 CF64 1C FB 04              TRB   MODE                     ;set mode bits
1512 CF67 8D 0F C0              STA   SETALTCHAR               ;and set alternate char set 
1513 CF6A 60                    RTS                            ;Back to caller
1514 CF6B
1515 CF6B
1516 CF6B
1517 CF6B
1518 CF6B                       TITLE 'Keyboard Input'
1519 CF6B
1520 CF6B              ******************************************************
1521 CF6B              *                                                    *
1522 CF6B              *          Monitor Keyboard Pickup Routines          *
1523 CF6B              *                                                    *
1524 CF6B              *                         by                         *
1525 CF6B              *                    Fern Bachman                    *
1526 CF6B              *                                                    *
1527 CF6B              *       Copyright Apple Computer, Inc. 1985-1987     *
1528 CF6B              *                All Rights Reserved.                *
1529 CF6B              *                                                    *
1530 CF6B              ******************************************************
1531 CF6B
1532 CF6B              * All input is directed through this code.
1533 CF6B              * It is done in case we change the way
1534 CF6B              * keyboard input is done in the future.
1535 CF6B
1536 CF6B              XRKBD1   EQU   *
1537 CF6B AD 00 C0              LDA   KBD                      ;test keyboard directly
1538 CF6E 10 04                 BPL   XRDKBD                   ;loop if buffered since test. 
1539 CF70 8D 10 C0              STA   KBDSTRB                  ;Clear keyboard strobe.
1540 CF73 60           XNOKEY   RTS                            ;Minus flag indicates valid character
1541 CF74
1542 CF74              XRDKBD   EQU   *
1543 CF74 20 94 CF              JSR   XBITKBD                  ;is keyboard input ready? 
1544 CF77 10 FA                 BPL   XNOKEY                   ;Branch if not.
1545 CF79 90 F0                 BCC   XRKBD1                   ;Branch if direct KBD input.
1546 CF7B
1547 CF7B                       IF IS512 <> 0 THEN 
1548 CF7B                       RTS                            ;Should never be executed
1549 CF7B                       ELSE 
1550 CF7B
1551 CF7B              * If here then event manager has a key for us.
1552 CF7B              * We probably should get it to humor the caller.
1553 CF7B
1554 CF7B              GETEVMEVENT EQU   *                     ;Get event manager key press event
1555 CF7B 48                    PHA                            ;Preserve 'A','X','Y'
1556 CF7C DA                    PHX                            ;
1557 CF7D 5A                    PHY                            ;
1558 CF7E 18                    CLC                            ;Be sure in native mode
1559 CF7F FB                    XCE                            ;
1560 CF80 08                    PHP                            ;Save entry status
1561 CF81 38                    SEC                            ;Indicate from here
1562 CF82 20 E2 CF              JSR   CALLEVM                  ;Call event manager
1563 CF85 F0 48                 BEQ   NOEVMKEYS                ;= then no event manager keys pressed
1564 CF87 28                    PLP                            ;Restore entry status
1565 CF88 FB                    XCE                            ;
1566 CF89 7A                    PLY                            ;Recall 'Y'
1567 CF8A FA                    PLX                            ;Recall 'X'
1568 CF8B 68                    PLA                            ;Recall entry 'A'
1569 CF8C AF 5A 01 E1           LDA   >EVMKEY                  ;Get key pressed from buffer
1570 CF90 09 80                 ORA   #$80                     ;ALWAYS set hi bit for monitor firmware
1571 CF92 38                    SEC                            ;Indicate key in 'A'
1572 CF93 60                    RTS                            ;Back to caller
1573 CF94
1574 CF94                       ENDIF 
1575 CF94
1576 CF94              XBITKBD  EQU   *                        ;This rtne replaces "BIT KBD" instructions
1577 CF94                       IF IS512 <> 0 THEN 
1578 CF94                       JMP   XBKB2                    ;Test hardware directly
1579 CF94                       ELSE 
1580 CF94
1581 CF94 48                    PHA                            ;MUST save accumulator unless key pressed
1582 CF95 DA                    PHX                            ;Preserve 'X'
1583 CF96 5A                    PHY                            ;Preserve 'Y'
1584 CF97 18                    CLC                            ;Switch to native mode and save entry mode
1585 CF98 FB                    XCE                            ;
1586 CF99 08                    PHP                            ;'c' has entry 'e' value in it
1587 CF9A C2 30                 REP   #$30                     ;16 bit land a must for tool calls
1588 CF9C F4 00 00              PEA   $0000                    ;Result byte
1589 CF9F                       LONGI ON
1590 CF9F A2 06 06              LDX   #ACTFN*256+EMTN          ;Function number*256+tool number
1591 CFA2                       LONGI OFF
1592 CFA2 22 00 00 E1           JSL   >DISPATCH1               ;Call tool locator
1593 CFA6 68                    PLA                            ;Recall active status
1594 CFA7 D0 07                 BNE   TSTNXTEVENT              ;<>= then event manager is active
1595 CFA9 28                    PLP                            ;Restore entry status
1596 CFAA FB                    XCE                            ;Restore entry stat (native or emulation)
1597 CFAB 7A                    PLY                            ;Recall 'Y'
1598 CFAC FA                    PLX                            ;Recall 'X'
1599 CFAD 68                    PLA                            ;Recall entry 'A'
1600 CFAE 80 28                 BRA   XBKB2                    ;Exit this way
1601 CFB0
1602 CFB0
1603 CFB0              TSTNXTEVENT EQU   *
1604 CFB0 E2 30                 SEP   #$30                     ;Fix CURSHIFTER for cursor flashing
1605 CFB2 A9 00                 LDA   #$00                     ;
1606 CFB4 8F 45 01 E1           STA   >CURSHIFTER              ;
1607 CFB8 18                    CLC                            ;Indicate from here
1608 CFB9 20 E2 CF              JSR   CALLEVM                  ;Call event manager
1609 CFBC F0 11                 BEQ   NOEVMKEYS                ;= then no event manager keys pressed
1610 CFBE 28                    PLP                            ;
1611 CFBF FB                    XCE                            ;
1612 CFC0 AF 58 01 E1           LDA   >WHATEVENT               ;What event now?
1613 CFC4 C9 0A                 CMP   #$0A                     ;$0A is desk accessory event
1614 CFC6 F0 15                 BEQ   TSTNXTEVENT2             ;= then cause desk acc event to happen
1615 CFC8 38                    SEC                            ;Indicate EVM active
1616 CFC9 7A                    PLY                            ;Recall 'Y'
1617 CFCA FA                    PLX                            ;Recall 'X'
1618 CFCB 68                    PLA                            ;Recall entry 'A'
1619 CFCC E2 80                 SEP   #$80                     ;'-' if key pressed
1620 CFCE 60                    RTS                            ;Back to caller
1621 CFCF
1622 CFCF              NOEVMKEYS EQU   *                       ;Branch here if no event mgr keys pressed
1623 CFCF 28                    PLP                            ;Restore entry status
1624 CFD0 FB                    XCE                            ;
1625 CFD1              NOEVMKEYS4 EQU   *
1626 CFD1 38                    SEC                            ;Indicate EVM active
1627 CFD2 7A                    PLY                            ;Recall 'Y'
1628 CFD3 FA                    PLX                            ;Recall 'X'
1629 CFD4 68                    PLA                            ;Recall entry 'A'
1630 CFD5 C2 80                 REP   #$80                     ;'+' if no key pressed
1631 CFD7 60                    RTS                            ;Back to caller
1632 CFD8
1633 CFD8                       ENDIF 
1634 CFD8
1635 CFD8
1636 CFD8 2C 00 C0     XBKB2    BIT   KBD                      ;test KBD Directly
1637 CFDB 18                    CLC                            ;indicate direct test
1638 CFDC 60                    RTS   
1639 CFDD
1640 CFDD
1641 CFDD                       IF IS512 <> 0 THEN 
1642 CFDD                       ELSE 
1643 CFDD
1644 CFDD
1645 CFDD              TSTNXTEVENT2 EQU   *
1646 CFDD 20 7B CF              JSR   GETEVMEVENT              ;Always allow desk acc event to work
1647 CFE0 80 EF                 BRA   NOEVMKEYS4               ;
1648 CFE2
1649 CFE2              CALLEVM  EQU   *                        ;Call event manager
1650 CFE2 C2 30                 REP   #$30                     ;16 bit land a must for tool calls
1651 CFE4 F4 00 00              PEA   $0000                    ;Result status
1652 CFE7 F4 28 04              PEA   $0428                    ;Look for dsk acc/auto repeat/key pressed
1653 CFEA F4 E1 00              PEA   EVMKEYBUFF>>16           ;Bank number of EVM key buffer
1654 CFED F4 58 01              PEA   |EVMKEYBUFF              ;Address number of EVM key buffer
1655 CFF0                       LONGI ON
1656 CFF0 A2 06 0A              LDX   #GNEFN*256+EMTN          ;Function number*256 + tool number
1657 CFF3 B0 03                 BCS   @1                       ;'c'=1 then skip next instruction
1658 CFF5 A2 06 0B              LDX   #EAFN*256+EMTN           ;Function number+256+tool number
1659 CFF8                       LONGI OFF
1660 CFF8              @1       EQU   *
1661 CFF8 22 00 00 E1           JSL   >DISPATCH1               ;Call tool locator
1662 CFFC 68                    PLA                            ;Was a key pressed?
1663 CFFD 60                    RTS                            ;Back to caller with call status in 'A'
1664 CFFE                       ENDIF 
1665 CFFE
1666 CFFE
1667 CFFE
1668 CFFE
1669 CFFE              * WARNING Instuction at $CFFE must NOT be one
1670 CFFE              *         that does false read to $CFFF.  An RTS
1671 CFFE              *         is an instruction which does a false
1672 CFFE              *         read of $CFFF and therefore cannot be
1673 CFFE              *         located at $CFFE.
1674 CFFE
1675 CFFE
